/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.swt.zenodo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.RequestBodyEntity;
import de.upb.cs.swt.zenodo.Deposition;
import de.upb.cs.swt.zenodo.DepositionFile;
import de.upb.cs.swt.zenodo.FileMetadata;
import de.upb.cs.swt.zenodo.Metadata;
import de.upb.cs.swt.zenodo.ZenodoAPI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZenodoClient
implements ZenodoAPI {
    private static final String productionToken = "tokengoeshere";
    private static final String sandboxToken = "tokengoeshere";
    private static final String sandboxURL = "https://sandbox.zenodo.org/";
    private static final String productionURL = "https://zenodo.org/";
    private final MyObjectMapper objectMapper;
    private String baseURL;
    private String token;

    public ZenodoClient(String baseURL, String token) {
        this.baseURL = baseURL;
        this.token = token;
        this.objectMapper = new MyObjectMapper(){
            final ISO8601DateFormat dateFormat = new ISO8601DateFormat(){

                public Date parse(String source) throws ParseException {
                    if (!source.endsWith("+0000") && !source.endsWith("+00:00")) {
                        source = source + "+0000";
                    }
                    return super.parse(source);
                }
            };
            private ObjectMapper jacksonObjectMapper = new ObjectMapper();
            {
                this.jacksonObjectMapper.setDateFormat((DateFormat)this.dateFormat);
                this.jacksonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public <T> T readValue(String value, TypeReference<T> valueType) {
                try {
                    return (T)this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)this.objectMapper);
    }

    @Override
    public boolean test() {
        GetRequest request = this.prepareGetRequest(this.baseURL + "api/deposit/depositions");
        try {
            HttpResponse response = request.asString();
            if (response.getStatus() == 200) {
                return true;
            }
        }
        catch (UnirestException unirestException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Deposition getDeposition(Integer id) {
        GetRequest request = this.prepareGetRequest(this.baseURL + "api/deposit/depositions/{id}");
        request.routeParam("id", id.toString());
        try {
            HttpResponse response = request.asObject(Deposition.class);
            return (Deposition)response.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Deposition> getDepositions() {
        ArrayList result = new ArrayList();
        GetRequest request = this.prepareGetRequest(this.baseURL + "api/deposit/depositions");
        try {
            ArrayList<Deposition> response = this.fromJSON(new TypeReference<ArrayList<Deposition>>(){}, (String)request.asString().getBody());
            return response;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Deposition updateDeposition(Deposition deposition) {
        HttpRequestWithBody request = this.preparePutRequest(this.baseURL + "api/deposit/depositions/{id}");
        request.routeParam("id", deposition.id.toString());
        try {
            HttpResponse response = request.asObject(Deposition.class);
            return (Deposition)response.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteDeposition(Integer id) {
        HttpRequestWithBody request = this.prepareDeleteRequest(this.baseURL + "api/deposit/depositions/{id}");
        request.routeParam("id", id.toString());
        try {
            HttpResponse httpResponse = request.asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    private <T> T fromJSON(TypeReference<T> type, String jsonPacket) {
        T data = null;
        try {
            data = this.objectMapper.readValue(jsonPacket, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public Deposition createDeposition() throws UnsupportedOperationException, IOException {
        return this.createDeposition(null);
    }

    @Override
    public Deposition createDeposition(final Metadata m) throws UnsupportedOperationException, IOException {
        HttpRequestWithBody post = this.preparePostRequest(this.baseURL + "api/deposit/depositions");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        String data = "{}";
        if (m != null) {
            data = this.objectMapper.writeValue(new Object(){
                public Metadata metadata;
                {
                    this.metadata = m;
                }
            });
        }
        RequestBodyEntity completePost = post.body(data);
        completePost.getEntity().writeTo((OutputStream)bytes);
        System.out.println(bytes.toString());
        try {
            HttpResponse response = completePost.asObject(Deposition.class);
            return (Deposition)response.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<DepositionFile> getFiles(Integer depositionId) {
        GetRequest request = this.prepareGetRequest(this.baseURL + "api/deposit/depositions/{id}/files");
        request.routeParam("id", depositionId.toString());
        try {
            ArrayList<DepositionFile> response = this.fromJSON(new TypeReference<ArrayList<DepositionFile>>(){}, (String)request.asString().getBody());
            return response;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DepositionFile uploadFile(final FileMetadata f, Integer depositionId) throws UnsupportedOperationException, IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HttpRequestWithBody post = this.preparePostFileRequest(this.baseURL + "api/deposit/depositions/{id}/files").routeParam("id", depositionId.toString());
        String data = "{}";
        data = this.objectMapper.writeValue(new Object(){
            public FileMetadata files;
            {
                this.files = f;
            }
        });
        RequestBodyEntity completePost = post.body(data);
        try {
            completePost.getEntity().writeTo((OutputStream)bytes);
            System.out.println(bytes.toString());
            HttpResponse response = completePost.asObject(DepositionFile.class);
            System.out.println(response.getStatus() + " " + response.getStatusText() + ((DepositionFile)response.getBody()).toString());
            return (DepositionFile)response.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean publish(Integer id) {
        HttpRequestWithBody post = this.preparePostRequest(this.baseURL + "api/deposit/depositions/{id}/actions/publish").routeParam("id", id.toString());
        try {
            HttpResponse response = post.asString();
            if (response.getStatus() == 202) {
                return true;
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean discard(Integer id) {
        HttpRequestWithBody post = this.preparePostRequest(this.baseURL + "api/deposit/depositions/{id}/actions/discard").routeParam("id", id.toString());
        try {
            HttpResponse response = post.asString();
            if (response.getStatus() == 201) {
                return true;
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return false;
    }

    private HttpRequestWithBody preparePostRequest(String url) {
        return Unirest.post((String)url).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.token);
    }

    private HttpRequestWithBody preparePostFileRequest(String url) {
        return Unirest.post((String)url).header("Content-Type", "application/octet-stream").header("Authorization", "Bearer " + this.token);
    }

    private GetRequest prepareGetRequest(String url) {
        return Unirest.get((String)url).header("Authorization", "Bearer " + this.token);
    }

    private HttpRequestWithBody preparePutRequest(String url) {
        return Unirest.put((String)url).header("Content-Type", "application/json").header("Authorization", "Bearer" + this.token);
    }

    private HttpRequestWithBody prepareDeleteRequest(String url) {
        return Unirest.delete((String)url).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.token);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MyObjectMapper
    implements com.mashape.unirest.http.ObjectMapper {
        private MyObjectMapper() {
        }

        public abstract <T> T readValue(String var1, TypeReference<T> var2);
    }
}

