/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.utilities.GatewayManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import java.io.Serializable;
import java.nio.file.Path;
import org.hyperledger.fabric.gateway.Gateway;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import scala.Function0;
import scala.Tuple2;

public final class ConnectionManager$ {
    public static final ConnectionManager$ MODULE$ = new ConnectionManager$();

    public Tuple2<ContractImpl, GatewayImpl> initializeConnection(String username, String channel, String chaincode, String contractName, Path walletPath, Path networkDescriptionPath) throws GatewayRuntimeException {
        return (Tuple2)PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((Function0 & Serializable)() -> {
            Logger$.MODULE$.info(new StringBuilder(38).append("Try to get connection with: '").append(networkDescriptionPath).append("' and: '").append(walletPath).append("'").toString());
            GatewayImpl gateway = GatewayManager$.MODULE$.createGateway(walletPath, networkDescriptionPath, username);
            ContractImpl contract = null;
            try {
                contract = MODULE$.retrieveContract(gateway, channel, chaincode, contractName);
            }
            catch (GatewayRuntimeException e) {
                GatewayManager$.MODULE$.disposeGateway((Gateway)gateway);
                throw Logger$.MODULE$.err(new StringBuilder(57).append("Could not retrieve contract ").append(contractName).append(" from chaincode ").append(chaincode).append(" in channel ").append(channel).append(".").toString(), (Exception)((Object)e));
            }
            return new Tuple2((Object)contract, (Object)gateway);
        }, channel, chaincode, ((Object)networkDescriptionPath).toString(), username, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
    }

    public String initializeConnection$default$2() {
        return "myc";
    }

    public String initializeConnection$default$3() {
        return "mycc";
    }

    private void checkConnectionInitialized(Network network) {
        if (!network.getChannel().isInitialized()) {
            throw new Exception("Network could not be initialized.");
        }
    }

    private ContractImpl retrieveContract(GatewayImpl gateway, String channelName, String chaincodeName, String contractName) throws GatewayRuntimeException {
        NetworkImpl network = (NetworkImpl)gateway.getNetwork(channelName);
        this.checkConnectionInitialized((Network)network);
        return (ContractImpl)network.getContract(chaincodeName, contractName);
    }

    private ConnectionManager$() {
    }
}

