/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities.helper;

import com.google.protobuf.ByteString;
import de.upb.cs.uc4.hyperledger.utilities.helper.ReflectionHelper$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TransactionHelper$ {
    public static final TransactionHelper$ MODULE$ = new TransactionHelper$();

    public Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> createTransactionInfo(ContractImpl contract, String transactionName, String[] params, Option<String> transactionId) {
        TransactionImpl transaction = (TransactionImpl)contract.createTransaction(transactionName);
        TransactionProposalRequest request = (TransactionProposalRequest)ReflectionHelper$.MODULE$.safeCallPrivateMethod(transaction, "newProposalRequest", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])params), ClassTag$.MODULE$.apply(String.class))}));
        TransactionContext context = (TransactionContext)request.getTransactionContext().get();
        if (transactionId.isDefined()) {
            ReflectionHelper$.MODULE$.setPrivateField(context, "txID", transactionId.get());
        }
        context.verify(request.doVerify());
        context.setProposalWaitTime(request.getProposalWaitTime());
        ReflectionHelper$.MODULE$.setPrivateField(transaction, "transactionContext", context);
        return new Tuple3((Object)transaction, (Object)context, (Object)request);
    }

    public String getTransactionIdFromProposal(ProposalPackage.Proposal proposal) {
        Common.Header header = Common.Header.parseFrom((ByteString)proposal.getHeader());
        Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
        String transactionId = channelHeader.getTxId();
        return transactionId;
    }

    public String getTransactionNameFromProposal(ProposalPackage.Proposal proposal) {
        Seq<String> args = this.getArgsFromProposal(proposal);
        String fcnName = (String)args.head();
        return this.getTransactionNameFromFcn(fcnName);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getTransactionParamsFromProposal(ProposalPackage.Proposal proposal) {
        void var3_3;
        Seq<String> args = this.getArgsFromProposal(proposal);
        Seq params = (Seq)args.tail();
        return var3_3;
    }

    public String getTransactionNameFromFcn(String fcn) {
        return fcn.substring(fcn.indexOf(":") + 1);
    }

    private Seq<String> getArgsFromProposal(ProposalPackage.Proposal proposal) {
        ByteString payloadBytes = proposal.getPayload();
        ProposalPackage.ChaincodeProposalPayload payload = ProposalPackage.ChaincodeProposalPayload.parseFrom((ByteString)payloadBytes);
        Chaincode.ChaincodeInvocationSpec invocationSpec = Chaincode.ChaincodeInvocationSpec.parseFrom((ByteString)payload.getInput());
        Chaincode.ChaincodeInput chaincodeInput = invocationSpec.getChaincodeSpec().getInput();
        List args = chaincodeInput.getArgsList();
        return ImplicitConversions$.MODULE$.iterator$u0020asScala(args.iterator()).map((Function1 & Serializable)b -> new String(b.toByteArray(), StandardCharsets.UTF_8)).toList();
    }

    private TransactionHelper$() {
    }
}

