/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities.helper;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.ReflectionHelper$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class TransactionHelper$ {
    public static final TransactionHelper$ MODULE$ = new TransactionHelper$();

    public Tuple3<String, String, String[]> getParametersFromApprovalProposal(ProposalPackage.Proposal proposal) {
        Seq<String> proposalParameters = this.getTransactionParamsFromProposal(proposal);
        String proposalContractName = (String)proposalParameters.head();
        String transactionName = (String)((IterableOps)proposalParameters.tail()).head();
        String paramsGson = (String)((IterableOps)((IterableOps)proposalParameters.tail()).tail()).head();
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("GSON:::: ").append(paramsGson).toString());
        String[] params = (String[])new Gson().fromJson(paramsGson, String[].class);
        return new Tuple3((Object)proposalContractName, (Object)transactionName, (Object)params);
    }

    public Seq<String> getApprovalTransactionFromParameters(String contractName, String transactionName, String[] params) {
        String jsonParams = new Gson().toJson((Object)params);
        List info = (List)new .colon.colon((Object)contractName, (List)new .colon.colon((Object)transactionName, (List)new .colon.colon((Object)jsonParams, (List)Nil$.MODULE$)));
        Logger$.MODULE$.info(new StringBuilder(15).append("approval info: ").append(info.foldLeft((Object)"", (Function2 & Serializable)(A, B) -> new StringBuilder(2).append((String)A).append("::").append((String)B).toString())).toString());
        return info;
    }

    public Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> createApprovalTransactionInfo(ContractImpl approvalContract, String contractName, String transactionName, String[] params, Option<String> transactionId) {
        Seq<String> approvalParams = this.getApprovalTransactionFromParameters(contractName, transactionName, params);
        return this.createTransactionInfo(approvalContract, "approveTransaction", (String[])approvalParams.toArray(ClassTag$.MODULE$.apply(String.class)), transactionId);
    }

    public Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> createTransactionInfo(ContractImpl contract, String transactionName, String[] params, Option<String> transactionId) {
        TransactionImpl transaction = (TransactionImpl)contract.createTransaction(transactionName);
        TransactionProposalRequest request = (TransactionProposalRequest)ReflectionHelper$.MODULE$.safeCallPrivateMethod(transaction, "newProposalRequest", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{params}));
        TransactionContext context = (TransactionContext)request.getTransactionContext().get();
        if (transactionId.isDefined()) {
            ReflectionHelper$.MODULE$.setPrivateField(context, "txID", transactionId.get());
        }
        Object object = request.getTransientMap() != null ? transaction.setTransient(request.getTransientMap()) : BoxedUnit.UNIT;
        context.verify(request.doVerify());
        context.setProposalWaitTime(request.getProposalWaitTime());
        ReflectionHelper$.MODULE$.setPrivateField(transaction, "transactionContext", context);
        return new Tuple3((Object)transaction, (Object)context, (Object)request);
    }

    public String getTransactionIdFromProposal(ProposalPackage.Proposal proposal) {
        Common.Header header = Common.Header.parseFrom((ByteString)proposal.getHeader());
        Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
        String transactionId = channelHeader.getTxId();
        return transactionId;
    }

    public String getTransactionNameFromProposal(ProposalPackage.Proposal proposal) {
        Seq<String> args = this.getArgsFromProposal(proposal);
        String fcnName = (String)args.head();
        return this.getTransactionNameFromFcn(fcnName);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getTransactionParamsFromProposal(ProposalPackage.Proposal proposal) {
        void var3_3;
        Seq<String> args = this.getArgsFromProposal(proposal);
        Seq params = (Seq)args.tail();
        return var3_3;
    }

    public String getTransactionNameFromFcn(String fcn) {
        return fcn.substring(fcn.indexOf(":") + 1);
    }

    private Seq<String> getArgsFromProposal(ProposalPackage.Proposal proposal) {
        ByteString payloadBytes = proposal.getPayload();
        ProposalPackage.ChaincodeProposalPayload payload = ProposalPackage.ChaincodeProposalPayload.parseFrom((ByteString)payloadBytes);
        Chaincode.ChaincodeInvocationSpec invocationSpec = Chaincode.ChaincodeInvocationSpec.parseFrom((ByteString)payload.getInput());
        Chaincode.ChaincodeInput chaincodeInput = invocationSpec.getChaincodeSpec().getInput();
        ByteString[] args = (ByteString[])CollectionConverters$.MODULE$.ListHasAsScala(chaincodeInput.getArgsList()).asScala().toArray(ClassTag$.MODULE$.apply(ByteString.class));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)b -> new String(b.toByteArray(), StandardCharsets.UTF_8), ClassTag$.MODULE$.apply(String.class))).toList();
    }

    private TransactionHelper$() {
    }
}

