/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.traits.WalletManagerTrait;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.Wallets;
import org.hyperledger.fabric.gateway.X509Identity;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class WalletManager$
implements WalletManagerTrait {
    public static final WalletManager$ MODULE$ = new WalletManager$();

    public Wallet getWallet(Path walletPath) {
        return Wallets.newFileSystemWallet((Path)walletPath);
    }

    @Override
    public X509Certificate getCertificate(Path walletPath, String id) {
        return (X509Certificate)PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((Function0 & Serializable)() -> MODULE$.getX509Identity(walletPath, id).getCertificate(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$2(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$3(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$4(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$5(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
    }

    public X509Identity getX509Identity(Path walletPath, String id) {
        return (X509Identity)this.getIdentity(this.getWallet(walletPath), id);
    }

    public X509Identity getX509Identity(Wallet wallet, String id) {
        return (X509Identity)this.getIdentity(wallet, id);
    }

    public Identity getIdentity(Path walletPath, String id) {
        return this.getIdentity(this.getWallet(walletPath), id);
    }

    public Identity getIdentity(Wallet wallet, String id) {
        if (!this.containsIdentity(wallet, id)) {
            throw Logger$.MODULE$.err(new StringBuilder(39).append("'").append(id).append("' credentials not found in wallet: '").append(wallet.toString()).append("'.").toString(), Logger$.MODULE$.err$default$2());
        }
        return wallet.get(id);
    }

    public void putIdentity(Path walletPath, String id, Identity identity) {
        this.putIdentity(this.getWallet(walletPath), id, identity);
    }

    public void putIdentity(Wallet wallet, String id, Identity identity) {
        if (this.containsIdentity(wallet, id)) {
            throw Logger$.MODULE$.err(new StringBuilder(68).append("'").append(id).append("' credentials already present in wallet: '").append(wallet.toString()).append("'. Cannot put two copies.").toString(), Logger$.MODULE$.err$default$2());
        }
        wallet.put(id, identity);
    }

    @Override
    public boolean containsIdentity(Path walletPath, String id) {
        return BoxesRunTime.unboxToBoolean(PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((JFunction0.mcZ.sp & Serializable)() -> MODULE$.containsIdentity(MODULE$.getWallet(walletPath), id), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$2(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$3(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$4(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$5(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7()));
    }

    public boolean containsIdentity(Wallet wallet, String id) {
        return wallet.list().contains(id);
    }

    private WalletManager$() {
    }
}

