/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.utilities.CAClientManager$;
import de.upb.cs.uc4.hyperledger.utilities.RegistrationManager$;
import de.upb.cs.uc4.hyperledger.utilities.WalletManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.traits.RegistrationManagerTrait;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Set;
import org.hyperledger.fabric.gateway.Identities;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import org.hyperledger.fabric_ca.sdk.RegistrationRequest;
import scala.Function0;
import scala.Predef$;

public final class RegistrationManager$
implements RegistrationManagerTrait {
    public static final RegistrationManager$ MODULE$ = new RegistrationManager$();

    @Override
    public String register(String caURL, Path caCert, String userName, String adminName, Path adminWalletPath, String affiliation, Integer maxEnrollments, String newUserType) throws Exception {
        Logger$.MODULE$.debug(new StringBuilder(54).append("Begin Registration process. Adding User '").append(userName).append("' as Admin '").append(adminName).append("'").toString());
        return (String)PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((Function0 & Serializable)() -> {
            String string;
            X509Identity adminIdentity = WalletManager$.MODULE$.getX509Identity(adminWalletPath, adminName);
            User admin = MODULE$.getUserFromX509Identity(adminIdentity, affiliation);
            RegistrationRequest registrationRequest = MODULE$.prepareRegistrationRequest(userName, maxEnrollments, newUserType);
            HFCAClient caClient = CAClientManager$.MODULE$.getCAClient(caURL, caCert);
            try {
                string = caClient.register(registrationRequest, admin);
            }
            catch (Exception e) {
                throw Logger$.MODULE$.err(new StringBuilder(40).append("Registration for the user '").append(userName).append("' went wrong.").toString(), e);
            }
            return string;
        }, null, null, null, adminName, null, affiliation);
    }

    @Override
    public Integer register$default$7() {
        return Predef$.MODULE$.int2Integer(1);
    }

    @Override
    public String register$default$8() {
        return "client";
    }

    private RegistrationRequest prepareRegistrationRequest(String userName, Integer maxEnrollments, String newUserType) {
        RegistrationRequest registrationRequest = new RegistrationRequest(userName);
        registrationRequest.setMaxEnrollments(Predef$.MODULE$.Integer2int(maxEnrollments));
        registrationRequest.setType(newUserType);
        return registrationRequest;
    }

    private Integer prepareRegistrationRequest$default$2() {
        return Predef$.MODULE$.int2Integer(1);
    }

    private String prepareRegistrationRequest$default$3() {
        return "client";
    }

    private User getUserFromX509Identity(X509Identity identity, String affiliationName) {
        String name = this.getNameFromIdentity(identity);
        return new User(name, affiliationName, identity){
            private final String name$1;
            private final String affiliationName$1;
            public final X509Identity identity$1;

            public String getName() {
                return this.name$1;
            }

            public Set<String> getRoles() {
                return null;
            }

            public String getAccount() {
                return "";
            }

            public String getAffiliation() {
                return this.affiliationName$1;
            }

            public Enrollment getEnrollment() {
                return new Enrollment(this){
                    private final /* synthetic */ anon.1 $outer;

                    public PrivateKey getKey() {
                        return this.$outer.identity$1.getPrivateKey();
                    }

                    public String getCert() {
                        return Identities.toPemString((Certificate)this.$outer.identity$1.getCertificate());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public String getMspId() {
                return this.identity$1.getMspId();
            }
            {
                this.name$1 = name$1;
                this.affiliationName$1 = affiliationName$1;
                this.identity$1 = identity$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private String getNameFromIdentity(X509Identity identity) {
        void var3_3;
        String rawName = identity.getCertificate().getSubjectDN().getName();
        String name = rawName.substring(rawName.indexOf("=") + 1);
        name = name.substring(0, name.indexOf(","));
        return var3_3;
    }

    private RegistrationManager$() {
    }
}

