/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities.helper;

import com.google.protobuf.ByteString;
import de.upb.cs.uc4.hyperledger.connections.traits.ConnectionOperationTrait;
import de.upb.cs.uc4.hyperledger.connections.traits.ConnectionTrait;
import de.upb.cs.uc4.hyperledger.utilities.helper.ReflectionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.helper.StringHelper$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.TimePeriod;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.gateway.impl.identity.GatewayUser;
import org.hyperledger.fabric.gateway.spi.CommitHandler;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.SDKUtils;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.hyperledger.fabric.sdk.security.CryptoPrimitives;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.transaction.ProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class TransactionHelper$ {
    public static final TransactionHelper$ MODULE$ = new TransactionHelper$();

    public Tuple2<String, Seq<String>> getParametersFromTransactionPayload(Common.Payload payload) {
        TransactionPackage.ChaincodeActionPayload chaincodeTransactionPayload = this.getChaincodeActionPayloadFromTransactionPayload(payload);
        ProposalPackage.ChaincodeProposalPayload chaincodeProposalPayload = ProposalPackage.ChaincodeProposalPayload.parseFrom((ByteString)chaincodeTransactionPayload.getChaincodeProposalPayload());
        Seq<String> args = this.getArgsFromChaincodeProposalPayload(chaincodeProposalPayload);
        return new Tuple2(args.head(), args.tail());
    }

    public TransactionPackage.ChaincodeActionPayload getChaincodeActionPayloadFromTransactionPayload(Common.Payload payload) {
        TransactionPackage.Transaction transaction = TransactionPackage.Transaction.parseFrom((ByteString)payload.getData());
        return TransactionPackage.ChaincodeActionPayload.parseFrom((ByteString)transaction.getActions(0).getPayload());
    }

    private Seq<String> getArgsFromChaincodeProposalPayload(ProposalPackage.ChaincodeProposalPayload payload) {
        Chaincode.ChaincodeInvocationSpec invocationSpec = Chaincode.ChaincodeInvocationSpec.parseFrom((ByteString)payload.getInput());
        Chaincode.ChaincodeInput chaincodeInput = invocationSpec.getChaincodeSpec().getInput();
        ByteString[] args = (ByteString[])CollectionConverters$.MODULE$.ListHasAsScala(chaincodeInput.getArgsList()).asScala().toArray(ClassTag$.MODULE$.apply(ByteString.class));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)b -> new String(b.toByteArray(), StandardCharsets.UTF_8), ClassTag$.MODULE$.apply(String.class))).toList();
    }

    public Seq<String> getApprovalParameterList(String initiator, String contractName, String transactionName, String[] params) {
        String jsonParams = StringHelper$.MODULE$.parameterArrayToJson(params);
        return (Seq)new .colon.colon((Object)initiator, (List)new .colon.colon((Object)contractName, (List)new .colon.colon((Object)transactionName, (List)new .colon.colon((Object)jsonParams, (List)Nil$.MODULE$))));
    }

    public Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> createTransactionInfo(ContractImpl contract, String transactionName, Seq<String> params, Option<String> transactionId) {
        TransactionImpl transaction = (TransactionImpl)contract.createTransaction(transactionName);
        TransactionProposalRequest request = (TransactionProposalRequest)ReflectionHelper$.MODULE$.safeCallPrivateMethod(transaction, "newProposalRequest", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{params.toArray(ClassTag$.MODULE$.apply(String.class))}));
        TransactionContext context = (TransactionContext)request.getTransactionContext().get();
        if (transactionId.isDefined()) {
            ReflectionHelper$.MODULE$.setPrivateField(context, "txID", transactionId.get());
        }
        Object object = request.getTransientMap() != null ? transaction.setTransient(request.getTransientMap()) : BoxedUnit.UNIT;
        context.verify(request.doVerify());
        context.setProposalWaitTime(request.getProposalWaitTime());
        ReflectionHelper$.MODULE$.setPrivateField(transaction, "transactionContext", context);
        return new Tuple3((Object)transaction, (Object)context, (Object)request);
    }

    public String getTransactionIdFromProposal(ProposalPackage.Proposal proposal) {
        return this.getTransactionIdFromHeader(Common.Header.parseFrom((ByteString)proposal.getHeader()));
    }

    /*
     * WARNING - void declaration
     */
    public String getTransactionIdFromHeader(Common.Header header) {
        void var3_3;
        Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
        String transactionId = channelHeader.getTxId();
        return var3_3;
    }

    public String getTransactionNameFromProposal(ProposalPackage.Proposal proposal) {
        Seq<String> args = this.getArgsFromProposal(proposal);
        String fcnName = (String)args.head();
        return this.getTransactionNameFromFcn(fcnName);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getTransactionParamsFromProposal(ProposalPackage.Proposal proposal) {
        void var3_3;
        Seq<String> args = this.getArgsFromProposal(proposal);
        Seq params = (Seq)args.tail();
        return var3_3;
    }

    public String getTransactionNameFromFcn(String fcn) {
        return fcn.substring(fcn.indexOf(":") + 1);
    }

    public Tuple2<TransactionImpl, ProposalPackage.SignedProposal> createSignedProposal(ConnectionOperationTrait operationConnection, ProposalPackage.Proposal proposal, ByteString signature) {
        TransactionImpl transaction;
        String transactionId = this.getTransactionIdFromProposal(proposal);
        String transactionName = this.getTransactionNameFromProposal(proposal);
        Seq<String> params = this.getTransactionParamsFromProposal(proposal);
        ProposalPackage.SignedProposal.Builder signedProposalBuilder = ProposalPackage.SignedProposal.newBuilder().setProposalBytes(proposal.toByteString()).setSignature(signature);
        ProposalPackage.SignedProposal signedProposal = signedProposalBuilder.build();
        Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> tuple3 = this.createTransactionInfo(operationConnection.contract(), transactionName, params, (Option<String>)new Some((Object)transactionId));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        TransactionImpl transactionImpl = transaction = (TransactionImpl)tuple3._1();
        TransactionImpl transaction2 = transactionImpl;
        return new Tuple2((Object)transaction2, (Object)signedProposal);
    }

    public byte[] createProposal(String certificate, String userAffiliation, String chaincodeName, String channelName, String function, Path networkDescriptionPath, Seq<String> args) {
        X509Enrollment enrollment = new X509Enrollment(new PrivateKey(){

            public String getAlgorithm() {
                return null;
            }

            public String getFormat() {
                return null;
            }

            public byte[] getEncoded() {
                return null;
            }
        }, certificate);
        GatewayUser user = new GatewayUser("gateway", userAffiliation, (Enrollment)enrollment);
        TransactionProposalRequest request = TransactionProposalRequest.newInstance((User)user);
        request.setChaincodeName(chaincodeName);
        request.setFcn(function);
        request.setArgs((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        File networkConfigFile = networkDescriptionPath.toFile();
        NetworkConfig networkConfig = NetworkConfig.fromYamlFile((File)networkConfigFile);
        HFClient hfClient = HFClient.createNewInstance();
        CryptoPrimitives crypto = new CryptoPrimitives();
        Integer securityLevel = Predef$.MODULE$.int2Integer(256);
        ReflectionHelper$.MODULE$.safeCallPrivateMethod(crypto, "setSecurityLevel", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{securityLevel}));
        hfClient.setCryptoSuite((CryptoSuite)crypto);
        hfClient.setUserContext((User)user);
        Channel channelObj = hfClient.loadChannelFromConfig(channelName, networkConfig);
        TransactionContext ctx = new TransactionContext(channelObj, (User)user, (CryptoSuite)crypto);
        Chaincode.ChaincodeID chaincodeId = Chaincode.ChaincodeID.newBuilder().setName(chaincodeName).build();
        ProposalPackage.Proposal proposal = ProposalBuilder.newBuilder().context(ctx).request((TransactionRequest)request).chaincodeID(chaincodeId).build();
        return proposal.toByteArray();
    }

    public Common.Payload getTransaction(Collection<ProposalResponse> validResponses, Channel channelObj) {
        HashSet invalid;
        int consistencyGroups;
        Channel.TransactionOptions transactionOptions = Channel.TransactionOptions.createTransactionOptions().nOfEvents(Channel.NOfEvents.createNoEvents());
        if (transactionOptions == null) {
            throw new InvalidArgumentException("Parameter transactionOptions can't be null");
        }
        ReflectionHelper$.MODULE$.safeCallPrivateMethod(channelObj, "checkChannelState", (Seq<Object>)Nil$.MODULE$);
        if (validResponses == null) {
            throw new InvalidArgumentException("sendTransaction proposalResponses was null");
        }
        if (((Config)ReflectionHelper$.MODULE$.getPrivateField(channelObj, "config")).getProposalConsistencyValidation() && ((consistencyGroups = SDKUtils.getProposalConsistencySets(validResponses, invalid = new HashSet()).size()) != 1 || !invalid.isEmpty())) {
            throw new IllegalArgumentException(String.format("The proposal responses have %d inconsistent groups with %d that are invalid. Expected all to be consistent and none to be invalid.", BoxesRunTime.boxToInteger((int)consistencyGroups), BoxesRunTime.boxToInteger((int)invalid.size())));
        }
        LinkedList ed = new LinkedList();
        ObjectRef proposal = ObjectRef.create(null);
        ObjectRef proposalResponsePayload = ObjectRef.create(null);
        ObjectRef proposalTransactionID = ObjectRef.create(null);
        ObjectRef transactionContext = ObjectRef.create(null);
        validResponses.forEach(sdkProposalResponse -> {
            ed.add(sdkProposalResponse.getProposalResponse().getEndorsement());
            if ((ProposalPackage.Proposal)proposal$1.elem == null) {
                proposal$1.elem = sdkProposalResponse.getProposal();
                proposalTransactionID$1.elem = sdkProposalResponse.getTransactionID();
                if ((String)proposalTransactionID$1.elem == null) {
                    throw new InvalidArgumentException("Proposals with missing transaction ID");
                }
                proposalResponsePayload$1.elem = sdkProposalResponse.getProposalResponse().getPayload();
                if ((ByteString)proposalResponsePayload$1.elem == null) {
                    throw new InvalidArgumentException("Proposals with missing payload.");
                }
                transactionContext$1.elem = (TransactionContext)ReflectionHelper$.MODULE$.safeCallPrivateMethod(sdkProposalResponse, "getTransactionContext", (Seq<Object>)Nil$.MODULE$);
                if ((TransactionContext)transactionContext$1.elem == null) {
                    throw new InvalidArgumentException("Proposals with missing transaction context.");
                }
            } else {
                String transactionID = sdkProposalResponse.getTransactionID();
                if (transactionID == null) {
                    throw new InvalidArgumentException("Proposals with missing transaction id.");
                }
                String string = (String)proposalTransactionID$1.elem;
                String string2 = transactionID;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new InvalidArgumentException(String.format("Proposals with different transaction IDs %s,  and %s", (String)proposalTransactionID$1.elem, transactionID));
                }
            }
        });
        return TransactionBuilder.newBuilder().chaincodeProposal((ProposalPackage.Proposal)proposal.elem).endorsements(ed).proposalResponsePayload((ByteString)proposalResponsePayload.elem).build();
    }

    public byte[] sendTransaction(ConnectionTrait connection, String channel, TransactionContext ctx, Channel channelObj, ByteString transactionPayloadBytes, byte[] signature, String proposalTransactionID) {
        byte[] byArray;
        CommitHandler commitHandler = connection.gateway().getCommitHandlerFactory().create(ctx.getTxID(), connection.gateway().getNetwork(channel));
        commitHandler.startListening();
        try {
            Channel.TransactionOptions transactionOptions = Channel.TransactionOptions.createTransactionOptions().nOfEvents(Channel.NOfEvents.createNoEvents());
            this.internalSendTransaction(channelObj, signature, transactionOptions, proposalTransactionID, transactionPayloadBytes).get(60L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            commitHandler.cancelListening();
            throw e;
        }
        catch (Exception e) {
            commitHandler.cancelListening();
            throw new ContractException("Failed to send transaction to the orderer", (Throwable)e);
        }
        TimePeriod commitTimeout = new TimePeriod(5L, TimeUnit.MINUTES);
        commitHandler.waitForEvents(commitTimeout.getTime(), commitTimeout.getTimeUnit());
        try {
            Common.Payload transactionPayload = Common.Payload.parseFrom((ByteString)transactionPayloadBytes);
            TransactionPackage.ChaincodeActionPayload chaincodeActionPayload = this.getChaincodeActionPayloadFromTransactionPayload(transactionPayload);
            ProposalResponsePackage.ProposalResponsePayload proposalResponsePayload = ProposalResponsePackage.ProposalResponsePayload.parseFrom((ByteString)chaincodeActionPayload.getAction().getProposalResponsePayload());
            ProposalPackage.ChaincodeAction chaincodeAction = ProposalPackage.ChaincodeAction.parseFrom((ByteString)proposalResponsePayload.getExtension());
            byArray = chaincodeAction.getResponse().getPayload().toByteArray();
        }
        catch (InvalidArgumentException e) {
            throw new GatewayRuntimeException((Throwable)e);
        }
        return byArray;
    }

    public CompletableFuture<BlockEvent.TransactionEvent> internalSendTransaction(Channel channel, byte[] signature, Channel.TransactionOptions transactionOptions, String proposalTransactionID, ByteString transactionPayload) {
        CompletableFuture<Object> completableFuture;
        block11: {
            try {
                java.util.List orderers = ReflectionHelper$.MODULE$.getPrivateField(transactionOptions, "orderers") != null ? (java.util.List)ReflectionHelper$.MODULE$.getPrivateField(transactionOptions, "orderers") : new ArrayList(channel.getOrderers());
                ArrayList shuffledOrderers = new ArrayList(orderers);
                if (BoxesRunTime.unboxToBoolean((Object)ReflectionHelper$.MODULE$.getPrivateField(transactionOptions, "shuffleOrders"))) {
                    Collections.shuffle(shuffledOrderers);
                }
                Common.Envelope transactionEnvelope = this.setTransactionSignature(transactionPayload, signature);
                Channel.NOfEvents nOfEvents = (Channel.NOfEvents)ReflectionHelper$.MODULE$.getPrivateField(transactionOptions, "nOfEvents");
                if (nOfEvents == null) {
                    BoxedUnit boxedUnit;
                    nOfEvents = Channel.NOfEvents.createNofEvents();
                    Collection eventingPeers = (Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "getEventingPeers", (Seq<Object>)Nil$.MODULE$);
                    boolean anyAdded = false;
                    if (!eventingPeers.isEmpty()) {
                        anyAdded = true;
                        boxedUnit = nOfEvents.addPeers(eventingPeers);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (!anyAdded) {
                        nOfEvents = Channel.NOfEvents.createNoEvents();
                    }
                } else if (nOfEvents != Channel.NOfEvents.nofNoEvents) {
                    StringBuilder issues = new StringBuilder(100);
                    Collection eventingPeers = (Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "getEventingPeers", (Seq<Object>)Nil$.MODULE$);
                    ((Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(nOfEvents, "unSeenPeers", (Seq<Object>)Nil$.MODULE$)).forEach(peer -> TransactionHelper$.foo$1(peer, issues, eventingPeers));
                    Object object = ((Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(nOfEvents, "unSeenPeers", (Seq<Object>)Nil$.MODULE$)).isEmpty() ? issues.append("NofEvents had no added  Peer eventing services.") : BoxedUnit.UNIT;
                    String foundIssues = issues.toString();
                    if (!foundIssues.isEmpty()) {
                        throw new InvalidArgumentException(foundIssues);
                    }
                }
                boolean replyOnly = nOfEvents == Channel.NOfEvents.nofNoEvents || ((Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "getEventingPeers", (Seq<Object>)Nil$.MODULE$)).isEmpty();
                CompletableFuture<Object> sret = null;
                sret = replyOnly ? new CompletableFuture<Object>() : (CompletableFuture<Object>)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "registerTxListener", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{proposalTransactionID, nOfEvents, ReflectionHelper$.MODULE$.getPrivateField(transactionOptions, "failFast")}));
                BooleanRef success = BooleanRef.create((boolean)false);
                ObjectRef lException = ObjectRef.create(null);
                ObjectRef resp = ObjectRef.create(null);
                ObjectRef failed = ObjectRef.create(null);
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> shuffledOrderers.forEach(orderer -> {
                    failed$1.elem = orderer;
                    try {
                        resp$1.elem = (Ab.BroadcastResponse)ReflectionHelper$.MODULE$.safeCallPrivateMethod(orderer, "sendTransaction", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{transactionEnvelope}));
                        lException$1.elem = null;
                        if (((Ab.BroadcastResponse)resp$1.elem).getStatus() == Common.Status.SUCCESS) {
                            success$1.elem = true;
                            throw Breaks$.MODULE$.break();
                        }
                    }
                    catch (Exception e) {
                        String exceptionMessage = String.format("Channel %s unsuccessful sendTransaction to orderer %s (%s)", channel.getName(), orderer.getName(), orderer.getUrl());
                        if ((Ab.BroadcastResponse)resp$1.elem != null) {
                            exceptionMessage = String.format("Channel %s unsuccessful sendTransaction to orderer %s (%s).  %s", channel.getName(), orderer.getName(), orderer.getUrl(), (String)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "getRespData", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{(Ab.BroadcastResponse)resp$1.elem})));
                        }
                        lException$1.elem = new Exception(exceptionMessage, e);
                    }
                }));
                if (success.elem) {
                    Object object = replyOnly ? BoxesRunTime.boxToBoolean((boolean)sret.complete(null)) : BoxedUnit.UNIT;
                    completableFuture = sret;
                    break block11;
                }
                String exceptionMessage = String.format("Channel %s failed to place transaction %s on Orderer. Cause: UNSUCCESSFUL. %s", channel.getName(), proposalTransactionID, (String)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "getRespData", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{(Ab.BroadcastResponse)resp.elem})));
                ReflectionHelper$.MODULE$.safeCallPrivateMethod(channel, "unregisterTxListener", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{proposalTransactionID}));
                CompletableFuture<Object> ret = new CompletableFuture<Object>();
                ret.completeExceptionally((Exception)lException.elem != null ? new Exception(exceptionMessage, (Exception)lException.elem) : new Exception(exceptionMessage));
                completableFuture = ret;
            }
            catch (Exception e) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(e);
                completableFuture = future;
            }
        }
        return completableFuture;
    }

    public Common.Envelope setTransactionSignature(ByteString transactionPayload, byte[] signature) {
        return Common.Envelope.newBuilder().setPayload(transactionPayload).setSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    private Seq<String> getArgsFromProposal(ProposalPackage.Proposal proposal) {
        ByteString payloadBytes = proposal.getPayload();
        ProposalPackage.ChaincodeProposalPayload payload = ProposalPackage.ChaincodeProposalPayload.parseFrom((ByteString)payloadBytes);
        return this.getArgsFromChaincodeProposalPayload(payload);
    }

    private static final Object foo$1(Peer peer, StringBuilder issues$1, Collection eventingPeers$1) {
        return ReflectionHelper$.MODULE$.safeCallPrivateMethod(peer, "getChannel", (Seq<Object>)Nil$.MODULE$) != MODULE$ ? issues$1.append(String.format("Peer %s added to NOFEvents does not belong this channel. ", peer.getName())) : (!eventingPeers$1.contains(peer) ? issues$1.append(String.format("Peer %s added to NOFEvents is not a eventing Peer in this channel. ", peer.getName())) : BoxedUnit.UNIT);
    }

    private TransactionHelper$() {
    }
}

