/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.connections.traits;

import com.google.protobuf.ByteString;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionAdmission;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionCertificate;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionExaminationRegulation;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionGroup;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionMatriculation;
import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionOperation;
import de.upb.cs.uc4.hyperledger.connections.traits.ConnectionOperationTrait;
import de.upb.cs.uc4.hyperledger.exceptions.HyperledgerException;
import de.upb.cs.uc4.hyperledger.exceptions.NetworkException;
import de.upb.cs.uc4.hyperledger.exceptions.NetworkException$;
import de.upb.cs.uc4.hyperledger.exceptions.TransactionException;
import de.upb.cs.uc4.hyperledger.exceptions.TransactionException$;
import de.upb.cs.uc4.hyperledger.exceptions.traits.HyperledgerExceptionTrait;
import de.upb.cs.uc4.hyperledger.exceptions.traits.NetworkExceptionTrait;
import de.upb.cs.uc4.hyperledger.exceptions.traits.TransactionExceptionTrait;
import de.upb.cs.uc4.hyperledger.utilities.ConnectionManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.CertificateHelper$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.ReflectionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.helper.StringHelper$;
import de.upb.cs.uc4.hyperledger.utilities.helper.TransactionHelper$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r%daB\u0014)!\u0003\r\ta\u000e\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u000b\u0017\u0002\u0001\n\u0011cb!\n\u0013a\u0005\u0002\u00031\u0001\u0011\u000b\u0007I\u0011A1\t\u0011U\u0003\u0001R1A\u0005\u0002\tD\u0001b\u0019\u0001\t\u0006\u0004%\t\u0001\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u001dI\bA1A\u0007\u00025DqA\u001f\u0001C\u0002\u001b\u0005Q\u000eC\u0004|\u0001\t\u0007i\u0011A7\t\u000fq\u0004!\u0019!D\u0001{\"A\u0011Q\u0002\u0001C\u0002\u001b\u0005Q\u0010\u0003\u0005\u0002\u0010\u0001\u0011\rQ\"\u0001n\u0011%\t\t\u0002\u0001a\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0001\u0002\u001e!I\u0011\u0011\u0005\u0001A\u0002\u0013\u0005\u00111\u0003\u0005\n\u0003G\u0001\u0001\u0019!C\u0001\u0003KAq!!\u0005\u0001\t\u000b\tI\u0003C\u0004\u0002\"\u0001!)!!\r\t\r\u0005U\u0002\u0001\"\u0012E\u0011\u0019\t9\u0004\u0001C\u0001[\"9\u0011\u0011\b\u0001\u0005\u0016\u0005m\u0002\"CA_\u0001E\u0005IQCA`\u0011%\tY\u000eAI\u0001\n+\ti\u000eC\u0004\u0002f\u0002!I!a:\t\u000f\t\u001d\u0001\u0001\"\u0006\u0003\n!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B(\u0001\u0011%!\u0011\u000b\u0005\b\u0005G\u0002A\u0011\u0002B3\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqAa \u0001\t+\u0011\t\tC\u0004\u00036\u0002!IAa.\t\u000f\t\u0015\b\u0001\"\u0003\u0003h\"91\u0011\u0002\u0001\u0005\u0002\r-\u0001bBB\u000b\u0001\u0011\u00051q\u0003\u0005\b\u0007s\u0001A\u0011AB\u001e\u0011%\u0019i\u0006AI\u0001\n\u0003\u0019y\u0006C\u0005\u0004b\u0001\t\n\u0011\"\u0001\u0004`!911\r\u0001\u0005\n\r\u0015$aD\"p]:,7\r^5p]R\u0013\u0018-\u001b;\u000b\u0005%R\u0013A\u0002;sC&$8O\u0003\u0002,Y\u0005Y1m\u001c8oK\u000e$\u0018n\u001c8t\u0015\tic&A\u0006isB,'\u000f\\3eO\u0016\u0014(BA\u00181\u0003\r)8\r\u000e\u0006\u0003cI\n!aY:\u000b\u0005M\"\u0014aA;qE*\tQ'\u0001\u0002eK\u000e\u00011c\u0001\u00019\u0001B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB(cU\u0016\u001cG\u000f\u0005\u0002:\u0003&\u0011!I\u000f\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\r\u0011Jg.\u001b;%)\u0005)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%\u0001B+oSR\f1\u0001\u001f\u00132+\u0005i\u0005\u0003\u0002$O!vK!aT$\u0003\rQ+\b\u000f\\33!\t\t6,D\u0001S\u0015\t\u0019F+\u0001\u0003j[Bd'BA+W\u0003\u001d9\u0017\r^3xCfT!a\u0016-\u0002\r\u0019\f'M]5d\u0015\ti\u0013LC\u0001[\u0003\ry'oZ\u0005\u00039J\u0013AbQ8oiJ\f7\r^%na2\u0004\"!\u00150\n\u0005}\u0013&aC$bi\u0016<\u0018-_%na2\f\u0001bY8oiJ\f7\r^\u000b\u0002!V\tQ,\u0001\u000bpa\u0016\u0014\u0018\r^5p]N\u001cuN\u001c8fGRLwN\\\u000b\u0002KB\u0019aI\u001a5\n\u0005\u001d<%AB(qi&|g\u000e\u0005\u0002jU6\t\u0001&\u0003\u0002lQ\tA2i\u001c8oK\u000e$\u0018n\u001c8Pa\u0016\u0014\u0018\r^5p]R\u0013\u0018-\u001b;\u0002\u0017\u00053e)\u0013'J\u0003RKuJT\u000b\u0002]B\u0011qN\u001e\b\u0003aR\u0004\"!]$\u000e\u0003IT!a\u001d\u001c\u0002\rq\u0012xn\u001c;?\u0013\t)x)\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;H\u0003!)8/\u001a:oC6,\u0017aB2iC:tW\r\\\u0001\nG\"\f\u0017N\\2pI\u0016\f!b^1mY\u0016$\b+\u0019;i+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003gS2,'bAA\u0004y\u0005\u0019a.[8\n\t\u0005-\u0011\u0011\u0001\u0002\u0005!\u0006$\b.\u0001\foKR<xN]6EKN\u001c'/\u001b9uS>t\u0007+\u0019;i\u00031\u0019wN\u001c;sC\u000e$h*Y7f\u0003M!\u0018.\\3pkRl\u0015\u000e\u001c7jg\u0016\u001cwN\u001c3t+\t\t)\u0002E\u0002G\u0003/I1!!\u0007H\u0005\rIe\u000e^\u0001\u0018i&lWm\\;u\u001b&dG.[:fG>tGm]0%KF$2!RA\u0010\u0011!Ye\"!AA\u0002\u0005U\u0011a\u0004;j[\u0016|W\u000f^!ui\u0016l\u0007\u000f^:\u0002'QLW.Z8vi\u0006#H/Z7qiN|F%Z9\u0015\u0007\u0015\u000b9\u0003\u0003\u0005L!\u0005\u0005\t\u0019AA\u000b)\u0011\tY#!\f\u0011\u0005%\u0004\u0001bBA\u0018#\u0001\u0007\u0011QC\u0001\u0007]\u0016<h+\u00197\u0015\t\u0005-\u00121\u0007\u0005\b\u0003_\u0011\u0002\u0019AA\u000b\u0003\u0015\u0019Gn\\:f\u0003M9W\r^\"iC&t7m\u001c3f-\u0016\u00148/[8o\u0003U9(/\u00199Tk\nl\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:$\u0002\"!\u0010\u0002H\u0005E\u0013Q\u000b\u000b\u0006]\u0006}\u00121\t\u0005\n\u0003\u0003*\u0002\u0013!a\u0001\u0003+\tA\u0003\u001d+j[\u0016|W\u000f^'jY2L7/Z2p]\u0012\u001c\b\"CA#+A\u0005\t\u0019AA\u000b\u0003A\u0001H+[7f_V$\u0018\t\u001e;f[B$8\u000fC\u0004\u0002JU\u0001\r!a\u0013\u0002\u0013Q\u0014\u0018M\\:jK:$\bc\u0001$\u0002N%\u0019\u0011qJ$\u0003\u000f\t{w\u000e\\3b]\"1\u00111K\u000bA\u00029\fq\u0002\u001e:b]N\f7\r^5p]:\u000bW.\u001a\u0005\b\u0003/*\u0002\u0019AA-\u0003\u0019\u0001\u0018M]1ngB!a)a\u0017o\u0013\r\tif\u0012\u0002\u000byI,\u0007/Z1uK\u0012t\u0004&B\u000b\u0002b\u0005U\u0004#\u0002$\u0002d\u0005\u001d\u0014bAA3\u000f\n1A\u000f\u001b:poN\u0004B!!\u001b\u0002r5\u0011\u00111\u000e\u0006\u0004S\u00055$bAA8Y\u0005QQ\r_2faRLwN\\:\n\t\u0005M\u00141\u000e\u0002\u001a\u0011f\u0004XM\u001d7fI\u001e,'/\u0012=dKB$\u0018n\u001c8Ue\u0006LG/\r\u0004\u001f]\u0006]\u0014qU\u0019\nG\u0005e\u0014qPAO\u0003\u0003+2!\\A>\t\u001d\tiH\u000eb\u0001\u0003\u000f\u0013\u0011\u0001V\u0005\u0005\u0003\u0003\u000b\u0019)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u000b;\u0015A\u0002;ie><8/\u0005\u0003\u0002\n\u0006=\u0005c\u0001$\u0002\f&\u0019\u0011QR$\u0003\u000f9{G\u000f[5oOB!\u0011\u0011SAL\u001d\r1\u00151S\u0005\u0004\u0003+;\u0015a\u00029bG.\fw-Z\u0005\u0005\u00033\u000bYJA\u0005UQJ|w/\u00192mK*\u0019\u0011QS$2\u0013\r\ny*!)\u0002$\u0006\u0015eb\u0001$\u0002\"&\u0019\u0011QQ$2\u000b\t2u)!*\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n9\u0007K\u0003\u0016\u0003W\u000b\u0019\fE\u0003G\u0003G\ni\u000b\u0005\u0003\u0002j\u0005=\u0016\u0002BAY\u0003W\u0012\u0011\u0004\u0016:b]N\f7\r^5p]\u0016C8-\u001a9uS>tGK]1jiF2aD\\A[\u0003w\u000b\u0014bIA=\u0003\u007f\n9,!!2\u0013\r\ny*!)\u0002:\u0006\u0015\u0015'\u0002\u0012G\u000f\u0006\u0015\u0016g\u0001\u0014\u0002.\u0006yrO]1q'V\u0014W.\u001b;Ue\u0006t7/Y2uS>tG\u0005Z3gCVdG\u000f\n\u001b\u0015\u0011\u0005\u0005\u0017Q[Al\u00033TC!!\u0006\u0002D.\u0012\u0011Q\u0019\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003%)hn\u00195fG.,GMC\u0002\u0002P\u001e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019.!3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004\u0002JY\u0001\r!a\u0013\t\r\u0005Mc\u00031\u0001o\u0011\u001d\t9F\u0006a\u0001\u00033\nqd\u001e:baN+(-\\5u)J\fgn]1di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136)!\t\t-a8\u0002b\u0006\r\bbBA%/\u0001\u0007\u00111\n\u0005\u0007\u0003':\u0002\u0019\u00018\t\u000f\u0005]s\u00031\u0001\u0002Z\u0005A\u0002O]5wCR,7+\u001e2nSR$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0011\u0005%\u0018Q_A|\u0003s\u0004RARAv\u0003_L1!!<H\u0005\u0015\t%O]1z!\r1\u0015\u0011_\u0005\u0004\u0003g<%\u0001\u0002\"zi\u0016Dq!!\u0013\u0019\u0001\u0004\tY\u0005\u0003\u0004\u0002Ta\u0001\rA\u001c\u0005\b\u0003/B\u0002\u0019AA-Q\u0015A\u0012\u0011MA\u007fc\u0019qb.a@\u0003\u0006EJ1%!\u001f\u0002\u0000\t\u0005\u0011\u0011Q\u0019\nG\u0005}\u0015\u0011\u0015B\u0002\u0003\u000b\u000bTA\t$H\u0003K\u000b4AJA4\u0003]9(/\u00199Fm\u0006dW/\u0019;f)J\fgn]1di&|g\u000eF\u0003o\u0005\u0017\u0011i\u0001\u0003\u0004\u0002Te\u0001\rA\u001c\u0005\b\u0003/J\u0002\u0019AA-Q\u0015I\u0012\u0011\rB\tc\u0019qbNa\u0005\u0003\u001aEJ1%!\u001f\u0002\u0000\tU\u0011\u0011Q\u0019\nG\u0005}\u0015\u0011\u0015B\f\u0003\u000b\u000bTA\t$H\u0003K\u000b4AJA4Q\u0015I\u00121\u0016B\u000fc\u0019qbNa\b\u0003&EJ1%!\u001f\u0002\u0000\t\u0005\u0012\u0011Q\u0019\nG\u0005}\u0015\u0011\u0015B\u0012\u0003\u000b\u000bTA\t$H\u0003K\u000b4AJAW\u0003i\u0001(/\u001b<bi\u0016,e/\u00197vCR,GK]1og\u0006\u001cG/[8o)\u0019\tIOa\u000b\u0003.!1\u00111\u000b\u000eA\u00029Dq!a\u0016\u001b\u0001\u0004\tI\u0006K\u0003\u001b\u0005c\u0011I\u0004E\u0003G\u0003G\u0012\u0019\u0004\u0005\u0003\u0002j\tU\u0012\u0002\u0002B\u001c\u0003W\u0012QCT3uo>\u00148.\u0012=dKB$\u0018n\u001c8Ue\u0006LG/\r\u0004\u001f]\nm\"\u0011I\u0019\nG\u0005e\u0014q\u0010B\u001f\u0003\u0003\u000b\u0014bIAP\u0003C\u0013y$!\"2\u000b\t2u)!*2\u0007\u0019\u0012\u0019\u0004K\u0003\u001b\u0003C\u0012)%\r\u0004\u001f]\n\u001d#QJ\u0019\nG\u0005e\u0014q\u0010B%\u0003\u0003\u000b\u0014bIAP\u0003C\u0013Y%!\"2\u000b\t2u)!*2\u0007\u0019\n9'A\tuKN$\u0018I\\=QCJ\fWn\u001d(vY2$R!\u0012B*\u0005+Ba!a\u0015\u001c\u0001\u0004q\u0007bBA,7\u0001\u0007\u0011\u0011\f\u0015\u00067\u0005-&\u0011L\u0019\u0007=9\u0014YF!\u00192\u0013\r\nI(a \u0003^\u0005\u0005\u0015'C\u0012\u0002 \u0006\u0005&qLACc\u0015\u0011ciRASc\r1\u0013QV\u0001\u0016oJ\f\u0007\u000f\u0016:b]N\f7\r^5p]J+7/\u001e7u)\u0015q'q\rB5\u0011\u0019\t\u0019\u0006\ba\u0001]\"9!1\u000e\u000fA\u0002\u0005%\u0018A\u0002:fgVdG\u000fK\u0003\u001d\u0003W\u0013y'\r\u0004\u001f]\nE$qO\u0019\nG\u0005e\u0014q\u0010B:\u0003\u0003\u000b\u0014bIAP\u0003C\u0013)(!\"2\u000b\t2u)!*2\u0007\u0019\ni+\u0001\u000fdQ\u0006LgnY8eKJ+7/\u001e7u\u0007>tG/Y5og\u0016\u0013(o\u001c:\u0015\t\u0005-#Q\u0010\u0005\u0007\u0005Wj\u0002\u0019\u00018\u0002q%tG/\u001a:oC2\f\u0005\u000f\u001d:pm\u0016\f5oQ;se\u0016tG/\u00118e\u000f\u0016$\bK]8q_N\fG\u000e\u0015:pa>\u001cX\r\u0016:b]N\f7\r^5p]RQ!1\u0011BC\u0005\u0013\u0013iIa$\u0011\u000b\u0019se.!;\t\r\t\u001de\u00041\u0001o\u0003-\u0019WM\u001d;jM&\u001c\u0017\r^3\t\r\t-e\u00041\u0001o\u0003-\tgMZ5mS\u0006$\u0018n\u001c8\t\r\u0005Mc\u00041\u0001o\u0011\u001d\t9F\ba\u0001\u00033BSAHAV\u0005'\u000bdA\b8\u0003\u0016\nm\u0015'C\u0012\u0002z\u0005}$qSAAc%\u0019\u0013qTAQ\u00053\u000b))M\u0003#\r\u001e\u000b)+M\u0002'\u0003[CSA\bB\u0019\u0005?\u000bdA\b8\u0003\"\n\u001d\u0016'C\u0012\u0002z\u0005}$1UAAc%\u0019\u0013qTAQ\u0005K\u000b))M\u0003#\r\u001e\u000b)+M\u0002'\u0005gASAHA1\u0005W\u000bdA\b8\u0003.\nM\u0016'C\u0012\u0002z\u0005}$qVAAc%\u0019\u0013qTAQ\u0005c\u000b))M\u0003#\r\u001e\u000b)+M\u0002'\u0003O\n\u0001#\u00199qe>4X-Q:DkJ\u0014XM\u001c;\u0015\u000f9\u0014IL!0\u0003@\"1!1X\u0010A\u00029\f\u0011\"\u001b8ji&\fGo\u001c:\t\r\u0005Ms\u00041\u0001o\u0011\u001d\t9f\ba\u0001\u0005\u0003\u0004RAa1\u0003J:tAA!2\u0002\u0014:\u0019\u0011Oa2\n\u0003!KAAa3\u0002\u001c\n\u00191+Z9)\u000b}\tYKa42\ryq'\u0011\u001bBlc%\u0019\u0013\u0011PA@\u0005'\f\t)M\u0005$\u0003?\u000b\tK!6\u0002\u0006F*!ER$\u0002&F\u001aa%!,)\u000b}\t\tGa72\ryq'Q\u001cBrc%\u0019\u0013\u0011PA@\u0005?\f\t)M\u0005$\u0003?\u000b\tK!9\u0002\u0006F*!ER$\u0002&F\u001aa%a\u001a\u0002+\u001d,G\u000f\u0015:pa>\u001c\u0018\r\u001c$pe\u0006\u0003\bO]8wKRA\u0011\u0011\u001eBu\u0005W\u0014i\u000f\u0003\u0004\u0003\b\u0002\u0002\rA\u001c\u0005\u0007\u0005\u0017\u0003\u0003\u0019\u00018\t\r\t=\b\u00051\u0001o\u0003-y\u0007/\u001a:bi&|g.\u00133)\u000b\u0001\nYKa=2\ryq'Q\u001fB~c%\u0019\u0013\u0011PA@\u0005o\f\t)M\u0005$\u0003?\u000b\tK!?\u0002\u0006F*!ER$\u0002&F\u001aa%!,)\u000b\u0001\n\tGa@2\ryq7\u0011AB\u0004c%\u0019\u0013\u0011PA@\u0007\u0007\t\t)M\u0005$\u0003?\u000b\tk!\u0002\u0002\u0006F*!ER$\u0002&F\u001aa%a\u001a\u0002-\u001d,G/\u00168tS\u001etW\r\u001a+sC:\u001c\u0018m\u0019;j_:$b!!;\u0004\u000e\rE\u0001bBB\bC\u0001\u0007\u0011\u0011^\u0001\u000eaJ|\u0007o\\:bY\nKH/Z:\t\u000f\rM\u0011\u00051\u0001\u0002j\u0006q1/[4oCR,(/\u001a\"zi\u0016\u001c\u0018aF:vE6LGoU5h]\u0016$GK]1og\u0006\u001cG/[8o)\u0015q7\u0011DB\u000f\u0011\u001d\u0019YB\ta\u0001\u0003S\f\u0001\u0003\u001e:b]N\f7\r^5p]\nKH/Z:\t\u000f\r}!\u00051\u0001\u0002j\u0006I1/[4oCR,(/\u001a\u0015\u0006E\u0005-61E\u0019\u0007=9\u001c)ca\u000b2\u0013\r\nI(a \u0004(\u0005\u0005\u0015'C\u0012\u0002 \u0006\u00056\u0011FACc\u0015\u0011ciRASc\r1\u0013Q\u0016\u0015\u0006E\u0005\u00054qF\u0019\u0007=9\u001c\tda\u000e2\u0013\r\nI(a \u00044\u0005\u0005\u0015'C\u0012\u0002 \u0006\u00056QGACc\u0015\u0011ciRASc\r1\u0013qM\u0001\u0013Kb,7-\u001e;f)J\fgn]1di&|g\u000eF\u0004o\u0007{\u0019\tea\u0011\t\r\r}2\u00051\u0001o\u0003EQ7o\u001c8Pa\u0016\u0014\u0018\r^5p]\u0012\u000bG/\u0019\u0005\n\u0003\u0003\u001a\u0003\u0013!a\u0001\u0003+A\u0011\"!\u0012$!\u0003\u0005\r!!\u0006)\u000b\r\nYka\u00122\ryq7\u0011JB(c%\u0019\u0013\u0011PA@\u0007\u0017\n\t)M\u0005$\u0003?\u000b\tk!\u0014\u0002\u0006F*!ER$\u0002&F\u001aa%!,)\u000b\r\n\tga\u00152\ryq7QKB.c%\u0019\u0013\u0011PA@\u0007/\n\t)M\u0005$\u0003?\u000b\tk!\u0017\u0002\u0006F*!ER$\u0002&F\u001aa%a\u001a\u00029\u0015DXmY;uKR\u0013\u0018M\\:bGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011Y\u0001\u001dKb,7-\u001e;f)J\fgn]1di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003i\u0011W/\u001b7e\u0007>tg.Z2uS>tgi\u001c:D_:$(/Y2u)\u0011\tYca\u001a\t\r\u0005=a\u00051\u0001o\u0001")
public interface ConnectionTrait
extends AutoCloseable {
    public void de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$_setter_$AFFILIATION_$eq(String var1);

    public static /* synthetic */ Tuple2 de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$$x$1$(ConnectionTrait $this) {
        return $this.de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$$x$1();
    }

    default public /* synthetic */ Tuple2 de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$$x$1() {
        ContractImpl contractImpl;
        GatewayImpl gateway;
        block3: {
            Tuple2<ContractImpl, GatewayImpl> tuple2;
            block2: {
                tuple2 = ConnectionManager$.MODULE$.initializeConnection(this.username(), this.channel(), this.chaincode(), this.contractName(), this.walletPath(), this.networkDescriptionPath());
                if (tuple2 == null) break block2;
                ContractImpl contract = (ContractImpl)tuple2._1();
                gateway = (GatewayImpl)tuple2._2();
                if (contract == null) break block2;
                contractImpl = contract;
                if (gateway != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        GatewayImpl gatewayImpl = gateway;
        Tuple2 tuple2 = new Tuple2((Object)contractImpl, (Object)gatewayImpl);
        return tuple2;
    }

    public static /* synthetic */ ContractImpl contract$(ConnectionTrait $this) {
        return $this.contract();
    }

    default public ContractImpl contract() {
        return (ContractImpl)this.de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$$x$1()._1();
    }

    public static /* synthetic */ GatewayImpl gateway$(ConnectionTrait $this) {
        return $this.gateway();
    }

    default public GatewayImpl gateway() {
        return (GatewayImpl)this.de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$$x$1()._2();
    }

    public static /* synthetic */ Option operationsConnection$(ConnectionTrait $this) {
        return $this.operationsConnection();
    }

    default public Option<ConnectionOperationTrait> operationsConnection() {
        return new Some((Object)new ConnectionOperation(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath()));
    }

    public String AFFILIATION();

    public String username();

    public String channel();

    public String chaincode();

    public Path walletPath();

    public Path networkDescriptionPath();

    public String contractName();

    public int timeoutMilliseconds();

    public void timeoutMilliseconds_$eq(int var1);

    public int timeoutAttempts();

    public void timeoutAttempts_$eq(int var1);

    public static /* synthetic */ ConnectionTrait timeoutMilliseconds$(ConnectionTrait $this, int newVal) {
        return $this.timeoutMilliseconds(newVal);
    }

    default public ConnectionTrait timeoutMilliseconds(int newVal) {
        this.timeoutMilliseconds_$eq(newVal);
        return this;
    }

    public static /* synthetic */ ConnectionTrait timeoutAttempts$(ConnectionTrait $this, int newVal) {
        return $this.timeoutAttempts(newVal);
    }

    default public ConnectionTrait timeoutAttempts(int newVal) {
        this.timeoutAttempts_$eq(newVal);
        return this;
    }

    public static /* synthetic */ void close$(ConnectionTrait $this) {
        $this.close();
    }

    @Override
    default public void close() {
        block0: {
            if (this.gateway() == null) break block0;
            this.gateway().close();
        }
    }

    public static /* synthetic */ String getChaincodeVersion$(ConnectionTrait $this) {
        return $this.getChaincodeVersion();
    }

    default public String getChaincodeVersion() {
        return this.wrapEvaluateTransaction("getVersion", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public static /* synthetic */ String wrapSubmitTransaction$(ConnectionTrait $this, boolean bl, String transactionName, Seq params, int pTimeoutMilliseconds, int pTimeoutAttempts) {
        return $this.wrapSubmitTransaction(bl, transactionName, (Seq<String>)params, pTimeoutMilliseconds, pTimeoutAttempts);
    }

    default public String wrapSubmitTransaction(boolean bl, String transactionName, Seq<String> params, int pTimeoutMilliseconds, int pTimeoutAttempts) throws TransactionExceptionTrait, HyperledgerExceptionTrait {
        byte[] resultBytes = (byte[])ReflectionHelper$.MODULE$.retryAction((Function0 & Serializable)() -> this.privateSubmitTransaction(bl, transactionName, params), transactionName, pTimeoutMilliseconds, pTimeoutAttempts);
        return this.wrapTransactionResult(transactionName, resultBytes);
    }

    public static /* synthetic */ int wrapSubmitTransaction$default$4$(ConnectionTrait $this, boolean bl, String transactionName, Seq params) {
        return $this.wrapSubmitTransaction$default$4(bl, transactionName, (Seq<String>)params);
    }

    default public int wrapSubmitTransaction$default$4(boolean bl, String transactionName, Seq<String> params) {
        return this.timeoutMilliseconds();
    }

    public static /* synthetic */ int wrapSubmitTransaction$default$5$(ConnectionTrait $this, boolean bl, String transactionName, Seq params) {
        return $this.wrapSubmitTransaction$default$5(bl, transactionName, (Seq<String>)params);
    }

    default public int wrapSubmitTransaction$default$5(boolean bl, String transactionName, Seq<String> params) {
        return this.timeoutAttempts();
    }

    private byte[] privateSubmitTransaction(boolean bl, String transactionName, Seq<String> params) throws HyperledgerExceptionTrait {
        byte[] byArray;
        Logger$.MODULE$.info(new StringBuilder(40).append("Submit Transaction: '").append(transactionName).append("' with parameters: ").append(params).toString());
        this.testAnyParamsNull(transactionName, params);
        try {
            if (bl) {
                IntRef i = IntRef.create((int)0);
                ObjectRef transMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                params.foreach((Function1 & Serializable)param -> {
                    ConnectionTrait.$anonfun$privateSubmitTransaction$1(transMap, i, param);
                    return BoxedUnit.UNIT;
                });
                byArray = this.contract().createTransaction(transactionName).setTransient(CollectionConverters$.MODULE$.MapHasAsJava((Map)((scala.collection.immutable.Map)transMap.elem)).asJava()).submit(new String[0]);
            } else {
                byArray = this.contract().submitTransaction(transactionName, (String[])params.toArray(ClassTag$.MODULE$.apply(String.class)));
            }
        }
        catch (GatewayRuntimeException ex) {
            GatewayRuntimeException x$1 = ex;
            String x$2 = NetworkException$.MODULE$.apply$default$1();
            String x$3 = NetworkException$.MODULE$.apply$default$2();
            String x$4 = NetworkException$.MODULE$.apply$default$3();
            String x$5 = NetworkException$.MODULE$.apply$default$4();
            String x$6 = NetworkException$.MODULE$.apply$default$5();
            String x$7 = NetworkException$.MODULE$.apply$default$6();
            throw new NetworkException(x$2, x$3, x$4, x$5, x$6, x$7, (Exception)((Object)x$1));
        }
        catch (TimeoutException ex) {
            TimeoutException x$8 = ex;
            String x$9 = NetworkException$.MODULE$.apply$default$1();
            String x$10 = NetworkException$.MODULE$.apply$default$2();
            String x$11 = NetworkException$.MODULE$.apply$default$3();
            String x$12 = NetworkException$.MODULE$.apply$default$4();
            String x$13 = NetworkException$.MODULE$.apply$default$5();
            String x$14 = NetworkException$.MODULE$.apply$default$6();
            throw new NetworkException(x$9, x$10, x$11, x$12, x$13, x$14, x$8);
        }
        catch (Exception ex) {
            throw new HyperledgerException(transactionName, ex);
        }
        return byArray;
    }

    public static /* synthetic */ String wrapEvaluateTransaction$(ConnectionTrait $this, String transactionName, Seq params) {
        return $this.wrapEvaluateTransaction(transactionName, (Seq<String>)params);
    }

    default public String wrapEvaluateTransaction(String transactionName, Seq<String> params) throws TransactionExceptionTrait, HyperledgerExceptionTrait {
        byte[] result = this.privateEvaluateTransaction(transactionName, params);
        return this.wrapTransactionResult(transactionName, result);
    }

    private byte[] privateEvaluateTransaction(String transactionName, Seq<String> params) throws HyperledgerExceptionTrait, NetworkExceptionTrait {
        byte[] byArray;
        Logger$.MODULE$.info(new StringBuilder(42).append("Evaluate Transaction: '").append(transactionName).append("' with parameters: ").append(params).toString());
        this.testAnyParamsNull(transactionName, params);
        try {
            byArray = this.contract().evaluateTransaction(transactionName, (String[])params.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        catch (GatewayRuntimeException ex) {
            GatewayRuntimeException x$1 = ex;
            String x$2 = NetworkException$.MODULE$.apply$default$1();
            String x$3 = NetworkException$.MODULE$.apply$default$2();
            String x$4 = NetworkException$.MODULE$.apply$default$3();
            String x$5 = NetworkException$.MODULE$.apply$default$4();
            String x$6 = NetworkException$.MODULE$.apply$default$5();
            String x$7 = NetworkException$.MODULE$.apply$default$6();
            throw new NetworkException(x$2, x$3, x$4, x$5, x$6, x$7, (Exception)((Object)x$1));
        }
        catch (TimeoutException ex) {
            TimeoutException x$8 = ex;
            String x$9 = NetworkException$.MODULE$.apply$default$1();
            String x$10 = NetworkException$.MODULE$.apply$default$2();
            String x$11 = NetworkException$.MODULE$.apply$default$3();
            String x$12 = NetworkException$.MODULE$.apply$default$4();
            String x$13 = NetworkException$.MODULE$.apply$default$5();
            String x$14 = NetworkException$.MODULE$.apply$default$6();
            throw new NetworkException(x$9, x$10, x$11, x$12, x$13, x$14, x$8);
        }
        catch (Exception ex) {
            throw new HyperledgerException(transactionName, ex);
        }
        return byArray;
    }

    private void testAnyParamsNull(String transactionName, Seq<String> params) throws TransactionExceptionTrait {
        if (params.contains(null)) {
            throw TransactionException$.MODULE$.CreateUnknownException(transactionName, "A parameter was null.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String wrapTransactionResult(String transactionName, byte[] result) throws TransactionExceptionTrait {
        void var3_3;
        String resultString = new String(result, StandardCharsets.UTF_8);
        Logger$.MODULE$.info(new StringBuilder(21).append("TRANSACTION RESULT:: ").append(resultString).toString());
        if (this.chaincodeResultContainsError(resultString)) {
            throw new TransactionException(transactionName, resultString);
        }
        return var3_3;
    }

    private boolean chaincodeResultContainsError(String result) {
        return result.contains("{\"type\":") && result.contains("\"title\":");
    }

    public static /* synthetic */ Tuple2 internalApproveAsCurrentAndGetProposalProposeTransaction$(ConnectionTrait $this, String certificate, String affiliation, String transactionName, Seq params) {
        return $this.internalApproveAsCurrentAndGetProposalProposeTransaction(certificate, affiliation, transactionName, (Seq<String>)params);
    }

    default public Tuple2<String, byte[]> internalApproveAsCurrentAndGetProposalProposeTransaction(String certificate, String affiliation, String transactionName, Seq<String> params) throws HyperledgerExceptionTrait, NetworkExceptionTrait, TransactionExceptionTrait {
        String initiator = CertificateHelper$.MODULE$.getNameFromCertificate(certificate);
        String adminApprovalResult = this.approveAsCurrent(initiator, transactionName, params);
        String operationId = StringHelper$.MODULE$.getOperationIdFromOperation(adminApprovalResult);
        byte[] proposalBytes = this.getProposalForApprove(certificate, affiliation, operationId);
        return new Tuple2((Object)adminApprovalResult, (Object)proposalBytes);
    }

    private String approveAsCurrent(String initiator, String transactionName, Seq<String> params) throws HyperledgerExceptionTrait, TransactionExceptionTrait {
        String approvalResult;
        block0: {
            approvalResult = "";
            if (!this.operationsConnection().isDefined()) break block0;
            approvalResult = ((ConnectionOperationTrait)this.operationsConnection().get()).initiateOperation(initiator, this.contractName(), transactionName, params);
        }
        return approvalResult;
    }

    private byte[] getProposalForApprove(String certificate, String affiliation, String operationId) throws HyperledgerExceptionTrait, TransactionExceptionTrait {
        byte[] proposal;
        block0: {
            proposal = null;
            if (!this.operationsConnection().isDefined()) break block0;
            proposal = ((ConnectionOperationTrait)this.operationsConnection().get()).getProposalApproveOperation(certificate, affiliation, operationId);
        }
        return proposal;
    }

    public static /* synthetic */ byte[] getUnsignedTransaction$(ConnectionTrait $this, byte[] proposalBytes, byte[] signatureBytes) {
        return $this.getUnsignedTransaction(proposalBytes, signatureBytes);
    }

    default public byte[] getUnsignedTransaction(byte[] proposalBytes, byte[] signatureBytes) {
        TransactionContext transactionContext;
        TransactionContext ctx;
        TransactionImpl transactionImpl;
        ProposalPackage.SignedProposal signedProposal;
        block5: {
            Tuple2<TransactionImpl, ProposalPackage.SignedProposal> tuple2;
            block4: {
                ByteString signature = ByteString.copyFrom((byte[])signatureBytes);
                ProposalPackage.Proposal proposal = ProposalPackage.Proposal.parseFrom((byte[])proposalBytes);
                tuple2 = TransactionHelper$.MODULE$.createSignedProposal((ConnectionOperationTrait)this, proposal, signature);
                if (tuple2 == null) break block4;
                TransactionImpl transaction = (TransactionImpl)tuple2._1();
                signedProposal = (ProposalPackage.SignedProposal)tuple2._2();
                if (transaction == null) break block4;
                transactionImpl = transaction;
                if (signedProposal != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        ProposalPackage.SignedProposal signedProposal2 = signedProposal;
        Tuple2 tuple2 = new Tuple2((Object)transactionImpl, (Object)signedProposal2);
        Tuple2 tuple22 = tuple2;
        TransactionImpl transaction = (TransactionImpl)tuple22._1();
        ProposalPackage.SignedProposal signedProposal3 = (ProposalPackage.SignedProposal)tuple22._2();
        Channel channelObj = this.gateway().getNetwork(this.channel()).getChannel();
        Collection peers = (Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channelObj, "getEndorsingPeers", (Seq<Object>)Nil$.MODULE$);
        ProposalPackage.Proposal transactionProposal = ProposalPackage.Proposal.parseFrom((byte[])proposalBytes);
        String transactionName = TransactionHelper$.MODULE$.getTransactionNameFromProposal(transactionProposal);
        Seq<String> transactionParams = TransactionHelper$.MODULE$.getTransactionParamsFromProposal(transactionProposal);
        String transactionId = TransactionHelper$.MODULE$.getTransactionIdFromProposal(transactionProposal);
        Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> tuple3 = TransactionHelper$.MODULE$.createTransactionInfo(this.contract(), transactionName, transactionParams, (Option<String>)new Some((Object)transactionId));
        if (tuple3 == null || (ctx = (TransactionContext)tuple3._2()) == null) {
            throw new MatchError(tuple3);
        }
        TransactionContext transactionContext2 = transactionContext = ctx;
        TransactionContext ctx2 = transactionContext2;
        Collection proposalResponses = (Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(channelObj, "sendProposalToPeers", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{peers, signedProposal3, ctx2}));
        Collection validResponses = (Collection)ReflectionHelper$.MODULE$.safeCallPrivateMethod(transaction, "validatePeerResponses", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{proposalResponses}));
        Common.Payload transactionPayload = (Common.Payload)ReflectionHelper$.MODULE$.retryAction((Function0 & Serializable)() -> TransactionHelper$.MODULE$.getTransaction(validResponses, channelObj), "getUnsignedTransaction", this.timeoutMilliseconds(), 1);
        return transactionPayload.toByteArray();
    }

    public static /* synthetic */ String submitSignedTransaction$(ConnectionTrait $this, byte[] transactionBytes, byte[] signature) {
        return $this.submitSignedTransaction(transactionBytes, signature);
    }

    default public String submitSignedTransaction(byte[] transactionBytes, byte[] signature) throws HyperledgerExceptionTrait, TransactionExceptionTrait {
        TransactionContext ctx;
        Common.Payload transactionPayload = Common.Payload.parseFrom((byte[])transactionBytes);
        String transactionId = TransactionHelper$.MODULE$.getTransactionIdFromHeader(transactionPayload.getHeader());
        Tuple2<String, Seq<String>> tuple2 = TransactionHelper$.MODULE$.getParametersFromTransactionPayload(transactionPayload);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String transactionName = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transactionName, (Object)params);
        Tuple2 tuple23 = tuple22;
        String transactionName2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        Tuple3<TransactionImpl, TransactionContext, TransactionProposalRequest> tuple3 = TransactionHelper$.MODULE$.createTransactionInfo(this.contract(), transactionName2, (Seq<String>)params2, (Option<String>)new Some((Object)transactionId));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        TransactionContext transactionContext = ctx = (TransactionContext)tuple3._2();
        TransactionContext ctx2 = transactionContext;
        byte[] response = TransactionHelper$.MODULE$.sendTransaction(this, this.channel(), ctx2, this.gateway().getNetwork(this.channel()).getChannel(), ByteString.copyFrom((byte[])transactionBytes), signature, transactionId);
        return this.wrapTransactionResult(transactionName2, response);
    }

    public static /* synthetic */ String executeTransaction$(ConnectionTrait $this, String jsonOperationData, int pTimeoutMilliseconds, int pTimeoutAttempts) {
        return $this.executeTransaction(jsonOperationData, pTimeoutMilliseconds, pTimeoutAttempts);
    }

    default public String executeTransaction(String jsonOperationData, int pTimeoutMilliseconds, int pTimeoutAttempts) throws HyperledgerExceptionTrait, TransactionExceptionTrait {
        String transactionInfo = StringHelper$.MODULE$.getTransactionInfoFromOperation(jsonOperationData);
        Tuple3<String, String, Seq<String>> tuple3 = StringHelper$.MODULE$.getInfoFromTransactionInfo(transactionInfo);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String contractName = (String)tuple3._1();
        String transactionName = (String)tuple3._2();
        Seq transactionParams = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)contractName, (Object)transactionName, (Object)transactionParams);
        Tuple3 tuple33 = tuple32;
        String contractName2 = (String)tuple33._1();
        String transactionName2 = (String)tuple33._2();
        Seq transactionParams2 = (Seq)tuple33._3();
        boolean transactionTransient = false;
        ConnectionTrait connection = this.buildConnectionForContract(contractName2);
        return connection.wrapSubmitTransaction(transactionTransient, transactionName2, (Seq<String>)transactionParams2, pTimeoutMilliseconds, pTimeoutAttempts);
    }

    public static /* synthetic */ int executeTransaction$default$2$(ConnectionTrait $this) {
        return $this.executeTransaction$default$2();
    }

    default public int executeTransaction$default$2() {
        return this.timeoutMilliseconds();
    }

    public static /* synthetic */ int executeTransaction$default$3$(ConnectionTrait $this) {
        return $this.executeTransaction$default$3();
    }

    default public int executeTransaction$default$3() {
        return this.timeoutAttempts();
    }

    private ConnectionTrait buildConnectionForContract(String contractName) {
        Product product;
        String string = contractName;
        if ("UC4.Admission".equals(string)) {
            product = new ConnectionAdmission(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath());
        } else if ("UC4.Certificate".equals(string)) {
            product = new ConnectionCertificate(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath());
        } else if ("UC4.ExaminationRegulation".equals(string)) {
            product = new ConnectionExaminationRegulation(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath());
        } else if ("UC4.Group".equals(string)) {
            product = new ConnectionGroup(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath());
        } else if ("UC4.MatriculationData".equals(string)) {
            product = new ConnectionMatriculation(this.username(), this.channel(), this.chaincode(), this.walletPath(), this.networkDescriptionPath());
        } else {
            throw new Exception(new StringBuilder(46).append("Cannot find suitable connection for contract: ").append(contractName).toString());
        }
        return product;
    }

    public static /* synthetic */ byte $anonfun$privateSubmitTransaction$2(char x$2) {
        return (byte)x$2;
    }

    public static /* synthetic */ void $anonfun$privateSubmitTransaction$1(ObjectRef transMap$1, IntRef i$1, String param) {
        transMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)transMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)i$1.elem)).toString()), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.charArrayOps(param.toCharArray()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ConnectionTrait.$anonfun$privateSubmitTransaction$2(BoxesRunTime.unboxToChar((Object)x$2))), (ClassTag)ClassTag$.MODULE$.Byte())));
        ++i$1.elem;
    }

    public static void $init$(ConnectionTrait $this) {
        $this.de$upb$cs$uc4$hyperledger$connections$traits$ConnectionTrait$_setter_$AFFILIATION_$eq("org1MSP");
        $this.timeoutMilliseconds_$eq(6000);
        $this.timeoutAttempts_$eq(10);
    }
}

