/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionCertificate;
import de.upb.cs.uc4.hyperledger.utilities.CAClientManager$;
import de.upb.cs.uc4.hyperledger.utilities.WalletManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.traits.EnrollmentManagerTrait;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.hyperledger.fabric.gateway.Identities;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric_ca.sdk.EnrollmentRequest;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class EnrollmentManager$
implements EnrollmentManagerTrait {
    public static final EnrollmentManager$ MODULE$ = new EnrollmentManager$();

    @Override
    public String enrollSecure(String caURL, Path caCert, String enrollmentID, String enrollmentSecret, String csr_pem, String adminName, Path adminWalletPath, String channel, String chaincode, Path networkDescriptionPath) {
        Logger$.MODULE$.debug(new StringBuilder(68).append("Begin Secure Enrollment process (CSR). Enrolling User '").append(enrollmentID).append("' as Admin '").append(adminName).append("'").toString());
        ObjectRef certificate = ObjectRef.create((Object)"");
        PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((JFunction0.mcV.sp & Serializable)() -> {
            HFCAClient caClient = CAClientManager$.MODULE$.getCAClient(caURL, caCert);
            EnrollmentRequest enrollmentRequestTLS = MODULE$.prepareEnrollmentRequest(enrollmentID, "tls", csr_pem);
            Enrollment enrollment = caClient.enroll(enrollmentID, enrollmentSecret, enrollmentRequestTLS);
            Logger$.MODULE$.info("Successfully performed and retrieved enrollment.");
            certificate$1.elem = enrollment.getCert();
            Logger$.MODULE$.info("Retrieved SignedCertificate.");
        }, channel, chaincode, ((Object)networkDescriptionPath).toString(), adminName, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
        this.putNewCertificateOnChain(adminName, channel, chaincode, adminWalletPath, networkDescriptionPath, enrollmentID, (String)certificate.elem);
        Logger$.MODULE$.debug("Finished Enrollment process (CSR).");
        return (String)certificate.elem;
    }

    private void putNewCertificateOnChain(String userName, String channel, String chaincode, Path connectionWalletPath, Path networkDescriptionPath, String newEnrollmentID, String newCertificate) {
        ConnectionCertificate certificateConnection = new ConnectionCertificate(userName, channel, chaincode, connectionWalletPath, networkDescriptionPath);
        this.addOrUpdateCertificate(certificateConnection, newEnrollmentID, newCertificate);
    }

    private String addOrUpdateCertificate(ConnectionCertificate certificateConnection, String enrollmentId, String enrollmentCertificate) {
        String string;
        try {
            Logger$.MODULE$.info(new StringBuilder(42).append("Try add new certificate for enrollmentID: ").append(enrollmentId).toString());
            string = certificateConnection.addCertificate(enrollmentId, enrollmentCertificate);
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.info(new StringBuilder(37).append("Certificate for user already exists: ").append(enrollmentId).toString());
            Logger$.MODULE$.info("Update Certificate");
            string = certificateConnection.updateCertificate(enrollmentId, enrollmentCertificate);
        }
        return string;
    }

    private EnrollmentRequest prepareEnrollmentRequest(String hostName, String profile, String csr_pem) {
        EnrollmentRequest enrollmentRequestTLS;
        block0: {
            enrollmentRequestTLS = new EnrollmentRequest();
            enrollmentRequestTLS.addHost(hostName);
            enrollmentRequestTLS.setProfile(profile);
            if (csr_pem == null) break block0;
            enrollmentRequestTLS.setCsr(csr_pem);
            enrollmentRequestTLS.setKeyPair(this.generateGarbageKeyPair());
        }
        return enrollmentRequestTLS;
    }

    private String prepareEnrollmentRequest$default$3() {
        return null;
    }

    private KeyPair generateGarbageKeyPair() {
        return KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }

    @Override
    public String enroll(String caURL, Path caCert, Path walletPath, String enrollmentID, String enrollmentSecret, String organisationId, String channel, String chaincode, Path networkDescriptionPath) {
        Logger$.MODULE$.debug(new StringBuilder(60).append("Begin regular Enrollment process (no CSR). Enrolling User '").append(enrollmentID).append("'").toString());
        ObjectRef certificate = ObjectRef.create((Object)"");
        if (WalletManager$.MODULE$.containsIdentity(walletPath, enrollmentID)) {
            Logger$.MODULE$.warn(new StringBuilder(162).append("\"\r\n           An identity for the user '").append(enrollmentID).append("' already exists in your wallet.\r\n           If you want to re-enroll, please delete the current identity file\r\n         \"").toString());
            certificate.elem = WalletManager$.MODULE$.getX509Identity(walletPath, enrollmentID).getCertificate().toString();
        } else {
            Logger$.MODULE$.info(new StringBuilder(23).append("Try to enroll user: '").append(enrollmentID).append("'.").toString());
            PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((JFunction0.mcV.sp & Serializable)() -> {
                HFCAClient caClient = CAClientManager$.MODULE$.getCAClient(caURL, caCert);
                EnrollmentRequest enrollmentRequestTLS = MODULE$.prepareEnrollmentRequest(enrollmentID, "tls", MODULE$.prepareEnrollmentRequest$default$3());
                Enrollment enrollment = caClient.enroll(enrollmentID, enrollmentSecret, enrollmentRequestTLS);
                certificate$2.elem = enrollment.getCert();
                Logger$.MODULE$.info("Successfully performed and retrieved enrollment");
                X509Identity identity = Identities.newX509Identity((String)organisationId, (Enrollment)enrollment);
                Logger$.MODULE$.info("Created identity from enrollment.");
                WalletManager$.MODULE$.putIdentity(walletPath, enrollmentID, (Identity)identity);
                Logger$.MODULE$.info(new StringBuilder(73).append("Successfully enrolled user ").append(enrollmentID).append(" and inserted the certificate into the wallet.").toString());
            }, channel, chaincode, ((Object)networkDescriptionPath).toString(), enrollmentID, organisationId, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
            this.putNewCertificateOnChain(enrollmentID, channel, chaincode, walletPath, networkDescriptionPath, enrollmentID, (String)certificate.elem);
        }
        Logger$.MODULE$.debug("Finished Enrollment process (no CSR).");
        return (String)certificate.elem;
    }

    @Override
    public String enrollSecure$default$5() {
        return null;
    }

    private EnrollmentManager$() {
    }
}

