/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.utilities.GatewayManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import java.io.Serializable;
import java.nio.file.Path;
import org.hyperledger.fabric.gateway.Contract;
import org.hyperledger.fabric.gateway.Gateway;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Network;
import scala.Function0;
import scala.Tuple2;

public final class ConnectionManager$ {
    public static final ConnectionManager$ MODULE$ = new ConnectionManager$();

    public Tuple2<Contract, Gateway> initializeConnection(String username, String channel, String chaincode, String contractName, Path walletPath, Path networkDescriptionPath) throws GatewayRuntimeException {
        return (Tuple2)PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((Function0 & Serializable)() -> {
            Logger$.MODULE$.info(new StringBuilder(38).append("Try to get connection with: '").append(networkDescriptionPath).append("' and: '").append(walletPath).append("'").toString());
            Gateway gateway = GatewayManager$.MODULE$.createGateway(walletPath, networkDescriptionPath, username);
            Contract contract = null;
            try {
                contract = MODULE$.retrieveContract(gateway, channel, chaincode, contractName);
            }
            catch (GatewayRuntimeException e) {
                GatewayManager$.MODULE$.disposeGateway(gateway);
                throw Logger$.MODULE$.err(new StringBuilder(57).append("Could not retrieve contract ").append(contractName).append(" from chaincode ").append(chaincode).append(" in channel ").append(channel).append(".").toString(), (Exception)((Object)e));
            }
            return new Tuple2((Object)contract, (Object)gateway);
        }, channel, chaincode, ((Object)networkDescriptionPath).toString(), username, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
    }

    public String initializeConnection$default$2() {
        return "myc";
    }

    public String initializeConnection$default$3() {
        return "mycc";
    }

    private void checkConnectionInitialized(Network network) {
        if (!network.getChannel().isInitialized()) {
            throw new Exception("Network could not be initialized.");
        }
    }

    private Contract retrieveContract(Gateway gateway, String channelName, String chaincodeName, String contractName) throws GatewayRuntimeException {
        Network network = gateway.getNetwork(channelName);
        this.checkConnectionInitialized(network);
        Contract contract = network.getContract(chaincodeName, contractName);
        return contract;
    }

    private ConnectionManager$() {
    }
}

