/*
 * Decompiled with CFR 0.152.
 */
package de.upb.cs.uc4.hyperledger.utilities;

import de.upb.cs.uc4.hyperledger.connections.cases.ConnectionCertificate;
import de.upb.cs.uc4.hyperledger.utilities.CAClientManager$;
import de.upb.cs.uc4.hyperledger.utilities.WalletManager$;
import de.upb.cs.uc4.hyperledger.utilities.helper.Logger$;
import de.upb.cs.uc4.hyperledger.utilities.helper.PublicExceptionHelper$;
import de.upb.cs.uc4.hyperledger.utilities.traits.EnrollmentManagerTrait;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.hyperledger.fabric.gateway.Identities;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric_ca.sdk.EnrollmentRequest;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import scala.Function0;
import scala.runtime.java8.JFunction0;

public final class EnrollmentManager$
implements EnrollmentManagerTrait {
    public static final EnrollmentManager$ MODULE$ = new EnrollmentManager$();

    @Override
    public String enrollSecure(String caURL, Path caCert, String enrollmentID, String enrollmentSecret, String csr_pem, String adminName, Path adminWalletPath, String channel, String chaincode, Path networkDescriptionPath) {
        return (String)PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((Function0 & Serializable)() -> {
            Logger$.MODULE$.info(new StringBuilder(42).append("Try to sign the certificate for the user ").append(enrollmentID).append(".").toString());
            HFCAClient caClient = CAClientManager$.MODULE$.getCAClient(caURL, caCert);
            Logger$.MODULE$.info("Successfully created a communication channel with the CA.");
            EnrollmentRequest enrollmentRequestTLS = MODULE$.prepareEnrollmentRequest(enrollmentID, "tls", csr_pem);
            Logger$.MODULE$.info("Successfully prepared the enrollmentRequest.");
            Enrollment enrollment = caClient.enroll(enrollmentID, enrollmentSecret, enrollmentRequestTLS);
            Logger$.MODULE$.info("Successfully performed and retrieved enrollment.");
            String certificate = enrollment.getCert();
            Logger$.MODULE$.info("Retrieved SignedCertificate.");
            ConnectionCertificate certificateConnection = new ConnectionCertificate(adminName, channel, chaincode, adminWalletPath, networkDescriptionPath);
            certificateConnection.addCertificate(enrollmentID, certificate);
            Logger$.MODULE$.info("Successfully stored cert on new chaincode");
            return certificate;
        }, channel, chaincode, ((Object)networkDescriptionPath).toString(), adminName, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$6(), PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
    }

    @Override
    public void enroll(String caURL, Path caCert, Path walletPath, String enrollmentID, String enrollmentSecret, String organisationId, String channel, String chaincode, Path networkDescriptionPath) {
        PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException((JFunction0.mcV.sp & Serializable)() -> {
            if (WalletManager$.MODULE$.containsIdentity(walletPath, enrollmentID)) {
                Logger$.MODULE$.warn(new StringBuilder(55).append("An identity for the user ").append(enrollmentID).append(" already exists in the wallet.").toString());
            } else {
                Logger$.MODULE$.info(new StringBuilder(38).append("Try to get the identity for the user ").append(enrollmentID).append(".").toString());
                HFCAClient caClient = CAClientManager$.MODULE$.getCAClient(caURL, caCert);
                EnrollmentRequest enrollmentRequestTLS = MODULE$.prepareEnrollmentRequest(enrollmentID, "tls", MODULE$.prepareEnrollmentRequest$default$3());
                Enrollment enrollment = caClient.enroll(enrollmentID, enrollmentSecret, enrollmentRequestTLS);
                Logger$.MODULE$.info("Successfully performed and retrieved enrollment");
                X509Identity identity = Identities.newX509Identity((String)organisationId, (Enrollment)enrollment);
                Logger$.MODULE$.info("Created identity from enrollment.");
                WalletManager$.MODULE$.putIdentity(walletPath, enrollmentID, (Identity)identity);
                Logger$.MODULE$.info(new StringBuilder(60).append("Successfully enrolled user ").append(enrollmentID).append(" and inserted it into the wallet.").toString());
                ConnectionCertificate certificateConnection = new ConnectionCertificate(enrollmentID, channel, chaincode, walletPath, networkDescriptionPath);
                certificateConnection.addCertificate(enrollmentID, enrollment.getCert());
                Logger$.MODULE$.info("Successfully stored cert on new chaincode");
            }
        }, channel, chaincode, ((Object)networkDescriptionPath).toString(), enrollmentID, organisationId, PublicExceptionHelper$.MODULE$.wrapInvocationWithNetworkException$default$7());
    }

    @Override
    public String enrollSecure$default$5() {
        return null;
    }

    private EnrollmentRequest prepareEnrollmentRequest(String hostName, String profile, String csr_pem) {
        EnrollmentRequest enrollmentRequestTLS;
        block0: {
            enrollmentRequestTLS = new EnrollmentRequest();
            enrollmentRequestTLS.addHost(hostName);
            enrollmentRequestTLS.setProfile(profile);
            if (csr_pem == null) break block0;
            enrollmentRequestTLS.setCsr(csr_pem);
            enrollmentRequestTLS.setKeyPair(this.generateGarbageKeyPair());
        }
        return enrollmentRequestTLS;
    }

    private String prepareEnrollmentRequest$default$3() {
        return null;
    }

    private KeyPair generateGarbageKeyPair() {
        return KeyPairGenerator.getInstance("RSA").generateKeyPair();
    }

    private EnrollmentManager$() {
    }
}

