/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.viewport.Viewport;
import de.verygame.surface.FPSOverlay;
import de.verygame.surface.event.Event;
import de.verygame.surface.event.EventListener;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.surface.screen.base.Screen;
import de.verygame.surface.screen.base.ScreenId;
import de.verygame.surface.screen.base.ScreenSwitch;

public abstract class BaseApplication
implements ApplicationListener,
EventListener {
    protected ResourceHandler resourceHandler;
    protected PolygonSpriteBatch batch;
    protected Viewport viewport;
    protected ScreenSwitch screenSwitch;
    protected FPSOverlay fpsOverlay;
    private boolean init = false;

    protected void add(ScreenId id, Screen screen) {
        if (this.batch == null) {
            throw new IllegalStateException("You must not call this method before create() has been called!");
        }
        this.screenSwitch.addScreen(id, screen);
    }

    protected void setActive(ScreenId id) {
        this.screenSwitch.setActive(id);
    }

    protected ScreenId getActiveScreenId() {
        return this.screenSwitch.getActiveScreenId();
    }

    protected abstract ScreenId createScreens();

    protected abstract Viewport createViewport();

    protected abstract void loadResources(ResourceHandler var1);

    public void create() {
        this.batch = new PolygonSpriteBatch();
        this.resourceHandler = new ResourceHandler();
        this.viewport = this.createViewport();
        this.screenSwitch = new ScreenSwitch();
        this.fpsOverlay = new FPSOverlay();
        this.screenSwitch.setBatch(this.batch);
        this.screenSwitch.addDependency("batch", this.batch);
        this.screenSwitch.addDependency("resourceHandler", this.resourceHandler);
        this.screenSwitch.addDependency("viewport", this.viewport);
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        this.screenSwitch.setInputHandler(inputMultiplexer);
        Gdx.input.setInputProcessor((InputProcessor)inputMultiplexer);
        this.preLoadResources(this.resourceHandler);
        this.screenSwitch.setActive(this.createLoadingScreen());
        this.loadResources(this.resourceHandler);
        this.init();
    }

    protected abstract ScreenId createLoadingScreen();

    protected void init() {
    }

    protected void postLoadResources(ResourceHandler res) {
    }

    protected void preLoadResources(ResourceHandler resourceHandler) {
    }

    protected boolean isDebug() {
        return false;
    }

    public void render() {
        this.screenSwitch.updateSwitch();
        this.screenSwitch.updateScreen();
        Gdx.gl.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.screenSwitch.renderScreen();
        if (this.isDebug()) {
            this.fpsOverlay.render((Batch)this.batch);
        }
        if (!this.init && this.resourceHandler.update()) {
            this.postLoadResources(this.resourceHandler);
            this.screenSwitch.setActive(this.createScreens());
            this.init = true;
        }
        this.batch.end();
    }

    public void resize(int width, int height) {
        this.screenSwitch.resize(width, height);
    }

    public void pause() {
        this.screenSwitch.pause();
    }

    public void resume() {
        this.screenSwitch.resume();
    }

    public void dispose() {
        this.screenSwitch.dispose();
        this.batch.dispose();
        this.resourceHandler.dispose();
    }

    @Override
    public void handleEvent(Event event, Object ... attachedObjects) {
    }
}

