/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.event;

import com.badlogic.gdx.Gdx;
import de.verygame.surface.event.Event;
import de.verygame.surface.event.EventListener;
import de.verygame.surface.event.EventRoute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventHandler {
    private final Map<EventListener, List<Event.EventType>> eventHandlerMap = new HashMap<EventListener, List<Event.EventType>>();
    private final Map<EventListener, Map<Event, Method>> cache = new HashMap<EventListener, Map<Event, Method>>();

    public void register(Event.EventType eventType, EventListener eventListener) {
        this.register(eventListener, eventType);
    }

    public void register(EventListener eventListener, Event.EventType ... type) {
        if (this.eventHandlerMap.containsKey(eventListener)) {
            Collections.addAll((Collection)this.eventHandlerMap.get(eventListener), type);
        } else {
            ArrayList list = new ArrayList(Event.EventType.values().length);
            Collections.addAll(list, type);
            this.eventHandlerMap.put(eventListener, list);
        }
    }

    public void unregister(EventListener eventListener, Event.EventType ... type) {
        if (this.eventHandlerMap.containsKey(eventListener)) {
            List<Event.EventType> list = this.eventHandlerMap.get(eventListener);
            if (list.size() == 1) {
                this.eventHandlerMap.remove(eventListener);
            } else {
                for (Event.EventType aType : type) {
                    list.remove((Object)aType);
                }
            }
        }
    }

    public boolean isRegistered(EventListener eventListener, Event.EventType eventType) {
        return this.eventHandlerMap.containsKey(eventListener) && this.eventHandlerMap.get(eventListener).contains((Object)eventType);
    }

    public void emitEvent(Event event, Object ... attachedObjects) {
        for (Map.Entry<EventListener, List<Event.EventType>> entry : this.eventHandlerMap.entrySet()) {
            EventListener eventListener = entry.getKey();
            boolean sendEvent = entry.getValue().contains((Object)event.getType());
            if (!sendEvent || this.emitReflectionEvent(eventListener, event, attachedObjects)) continue;
            eventListener.handleEvent(event, attachedObjects);
        }
    }

    private boolean emitReflectionEvent(EventListener target, Event event, Object ... attached) {
        if (this.cache.containsKey(target)) {
            Map<Event, Method> methodMap = this.cache.get(target);
            if (methodMap.containsKey((Object)event)) {
                Method method = methodMap.get((Object)event);
                try {
                    method.invoke((Object)target, attached);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.printReflectionError(e);
                    return false;
                }
            }
        } else {
            this.cache.put(target, new EnumMap(Event.class));
        }
        for (Method method : target.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventRoute.class) || method.getAnnotation(EventRoute.class).value() != event) continue;
            try {
                method.setAccessible(true);
                method.invoke((Object)target, attached);
                this.cache.get(target).put(event, method);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.printReflectionError(e);
            }
        }
        return false;
    }

    private void printReflectionError(Exception e) {
        Gdx.app.error(this.getClass().getSimpleName(), "An " + e.getClass().getSimpleName() + " has occurred. Reason: " + e.getMessage(), (Throwable)e);
    }
}

