/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.resource;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.I18NBundle;
import de.verygame.surface.util.FileUtils;

public enum ResourceType {
    TEX(FileUtils.toPath("tex"), Texture.class),
    TEX_ATLAS(FileUtils.toPath("atlas"), TextureAtlas.class),
    XML(FileUtils.toPath("xml"), String.class),
    LANG(FileUtils.toPath("lang"), I18NBundle.class),
    FONT(FileUtils.toPath("font"), FreeTypeFontGenerator.class),
    SKIN(FileUtils.toPath("skin"), Skin.class);

    private Class<?> targetClass;
    private String basePath;

    private ResourceType(String resourceRootPath, Class<?> targetClass) {
        this.targetClass = targetClass;
        this.basePath = resourceRootPath;
    }

    public Class<?> getTarget() {
        return this.targetClass;
    }

    public String getRoot() {
        return this.basePath;
    }

    public String toString() {
        return this.basePath;
    }
}

