/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.resource;

import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceDescriptor;
import de.verygame.surface.resource.ResourceUnit;
import de.verygame.surface.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResourceUtils {
    private static final String ENUM_METHOD_NAME = "values";
    private static final List<Class<? extends Resource>> resourceClasses = new ArrayList<Class<? extends Resource>>();
    private static final List<Class<? extends ResourceUnit>> resourceUnitClasses = new ArrayList<Class<? extends ResourceUnit>>();

    private ResourceUtils() {
    }

    @SafeVarargs
    public static void addResourceImplementation(Class<? extends Resource> ... resourceImplementations) {
        Collections.addAll(resourceClasses, resourceImplementations);
    }

    @SafeVarargs
    public static void addResourceUnitImplementation(Class<? extends ResourceUnit> ... resourceUnitImplementations) {
        Collections.addAll(resourceUnitClasses, resourceUnitImplementations);
    }

    public static <T extends ResourceDescriptor> T lookUp(String resourceName, Class<T> yourClass) {
        List<Class<ResourceDescriptor>> resourceSet = yourClass == Resource.class ? resourceClasses : resourceUnitClasses;
        for (Class<ResourceDescriptor> resourceClass : resourceSet) {
            Class<ResourceDescriptor> enumResource;
            Method valuesMethod;
            Enum[] enums;
            if (!resourceClass.isEnum() || (enums = (Enum[])ReflectionUtils.invokeMethod(valuesMethod = ReflectionUtils.retrieveMethod(enumResource = resourceClass, ENUM_METHOD_NAME, new Class[0]), null, new Object[0])) == null) continue;
            for (Enum en : enums) {
                if (!en.name().equals(resourceName)) continue;
                return (T)((ResourceDescriptor)((Object)en));
            }
        }
        return null;
    }
}

