/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.resource.loader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import java.io.BufferedReader;
import java.io.IOException;

public class StringLoader
extends AsynchronousAssetLoader<String, StringParameter> {
    private String result;

    public StringLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, StringParameter parameter) {
        try {
            StringParameter para = parameter == null ? new StringParameter() : parameter;
            BufferedReader bufferedReader = file.reader(para.bufferSize, para.charset);
            StringBuilder builder = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(line);
                line = bufferedReader.readLine();
            }
            this.result = builder.toString();
        }
        catch (IOException e) {
            Gdx.app.error("IOError", "A error occurred caused while reading:" + fileName, (Throwable)e);
        }
    }

    public String loadSync(AssetManager manager, String fileName, FileHandle file, StringParameter parameter) {
        return this.result;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, StringParameter parameter) {
        return null;
    }

    public static class StringParameter
    extends AssetLoaderParameters<String> {
        private static final int STD_BUFFER = 1024;
        private static final String STD_CHARSET = "UTF-8";
        public String charset = "UTF-8";
        public int bufferSize = 1024;
    }
}

