/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class Panel
extends WidgetGroup {
    private Drawable background;
    private float xPadding = 0.0f;
    private float yPadding = 0.0f;
    private Matrix4 oldM = new Matrix4();

    public Panel(Drawable background) {
        this.setBackground(background);
    }

    public void setXPadding(float xPadding) {
        this.xPadding = xPadding;
    }

    public void setYPadding(float yPadding) {
        this.yPadding = yPadding;
    }

    public void setAlpha(float alpha) {
        this.getColor().a = alpha;
    }

    public void setBackground(Drawable background) {
        this.background = background;
    }

    public void draw(Batch batch, float parentAlpha) {
        if (this.background != null) {
            batch.setColor(this.getColor());
            this.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            batch.setColor(Color.WHITE);
        }
        float absoluteXPadding = this.xPadding * this.getWidth();
        float absoluteYPadding = this.yPadding * this.getHeight();
        this.oldM.set(batch.getProjectionMatrix());
        batch.getProjectionMatrix().translate(absoluteXPadding, absoluteYPadding, 0.0f);
        super.draw(batch, parentAlpha);
        batch.setProjectionMatrix(this.oldM);
    }
}

