/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.xue;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.surface.scene2d.widget.Panel;
import de.verygame.surface.scene2d.widget.Switch;
import de.verygame.surface.scene2d.xue.element.ButtonTag;
import de.verygame.surface.scene2d.xue.element.ContainerTag;
import de.verygame.surface.scene2d.xue.element.ElementTag;
import de.verygame.surface.scene2d.xue.element.ImageTag;
import de.verygame.surface.scene2d.xue.element.LabelTag;
import de.verygame.surface.scene2d.xue.element.PanelTag;
import de.verygame.surface.scene2d.xue.element.SliderTag;
import de.verygame.xue.mapping.TagMapping;
import de.verygame.xue.mapping.tag.XueTag;

public class ElementMapping
implements TagMapping<Actor> {
    private final ResourceHandler resourceHandler;
    private final Resource skinResource;

    public ElementMapping(ResourceHandler resourceHandler, Resource skinResource) {
        this.resourceHandler = resourceHandler;
        this.skinResource = skinResource;
    }

    public XueTag<? extends Actor> createTag(String name) {
        Skin skin = this.resourceHandler.get(this.skinResource, Skin.class);
        switch (name) {
            case "button": {
                return new ButtonTag(skin, this.resourceHandler);
            }
            case "checkbox": {
                return new ElementTag<CheckBox>(new CheckBox("", skin));
            }
            case "dialog": {
                return new ElementTag<Dialog>(new Dialog("", skin));
            }
            case "imageButton": {
                return new ElementTag<ImageButton>(new ImageButton(skin));
            }
            case "scrollPane": {
                return new ElementTag<ScrollPane>(new ScrollPane(null, skin));
            }
            case "splitPane": {
                return new ElementTag<SplitPane>(new SplitPane(null, null, true, skin));
            }
            case "table": {
                return new ElementTag<Table>(new Table(skin));
            }
            case "container": {
                return new ContainerTag<Container>(new Container());
            }
            case "panel": {
                return new PanelTag(new Panel(null), this.resourceHandler);
            }
            case "switch": {
                return new ElementTag<Switch>(new Switch(skin, null));
            }
            case "label": {
                return new LabelTag(skin, this.resourceHandler);
            }
            case "image": {
                return new ImageTag(new Image(), this.resourceHandler);
            }
            case "progressBar": {
                return new ElementTag<ProgressBar>(new ProgressBar(0.0f, 100.0f, 1.0f, false, skin));
            }
            case "select": {
                return new ElementTag<SelectBox>(new SelectBox(skin));
            }
            case "slider": {
                return new SliderTag(skin);
            }
            case "textArea": {
                return new ElementTag<TextArea>(new TextArea("", skin));
            }
            case "textField": {
                return new ElementTag<TextField>(new TextField("", skin));
            }
        }
        return null;
    }
}

