/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.xue.element.attribute;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import de.verygame.surface.util.ColorUtils;
import de.verygame.xue.mapping.tag.attribute.AbstractAttribute;

public class ColorAttribute
extends AbstractAttribute<Actor, String> {
    private static final String NAME = "color";

    public String getName() {
        return NAME;
    }

    public void apply(Actor element, String value) {
        if (value.startsWith("rgba(")) {
            String[] n = value.substring(5, value.length() - 1).split(",");
            if (n.length != 4) {
                throw new IllegalArgumentException("You have to provide values for r, g, b and a!");
            }
            element.getColor().set((float)Integer.parseInt(n[0].trim()) / 255.0f, (float)Integer.parseInt(n[1].trim()) / 255.0f, (float)Integer.parseInt(n[2].trim()) / 255.0f, Float.parseFloat(n[3].trim()));
        } else if (value.startsWith("#")) {
            Color color = ColorUtils.fromHex(value);
            element.setColor(color);
        }
    }
}

