/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.xue.element.attribute;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.surface.resource.ResourceUtils;
import de.verygame.surface.util.FontUtils;
import de.verygame.xue.annotation.AttributeHandler;
import de.verygame.xue.mapping.tag.attribute.AbstractAttributeGroup;
import de.verygame.xue.mapping.tag.attribute.AttributeGroupElementMeta;
import de.verygame.xue.util.GroupMetaUtils;
import java.util.List;

public class FontGroupAttribute
extends AbstractAttributeGroup<Label> {
    public static final String DEFAULT_CHARS = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00fc\u00e4\u00f61234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    private final ResourceHandler res;
    private Resource font = null;
    private int fontSize = -1;
    private boolean dirty = false;
    private boolean first = true;

    public FontGroupAttribute(ResourceHandler resourceHandler) {
        this.res = resourceHandler;
    }

    public List<AttributeGroupElementMeta> getGroupMeta() {
        return GroupMetaUtils.buildMetaList((String[])new String[]{"font", "fontSize"}, (Class[])new Class[]{String.class, Float.class});
    }

    @AttributeHandler
    public void applyFont(Label element, String value) {
        Resource newFont = ResourceUtils.lookUp(value, Resource.class);
        if (this.font != newFont) {
            this.font = newFont;
            this.dirty = true;
        }
    }

    @AttributeHandler
    public void applyFontSize(Label element, Float value) {
        if ((float)this.fontSize != value.floatValue()) {
            this.fontSize = (int)value.floatValue();
            this.dirty = true;
        }
    }

    public void end(Label element) {
        if (this.first) {
            this.res.increaseCachedFontReferenceCount(element.getStyle().font);
            this.first = false;
        }
        if (this.dirty && this.font != null && this.fontSize != -1) {
            FreeTypeFontGenerator.FreeTypeFontParameter para = FontUtils.obtainParameterBuilder().size(this.fontSize).character(DEFAULT_CHARS).build();
            BitmapFont old = element.getStyle().font;
            element.getStyle().font = this.res.createCachedFont(this.font, para);
            element.setStyle(element.getStyle());
            this.res.destroyCachedFont(old);
            this.dirty = false;
        }
    }
}

