/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.transition;

import de.verygame.surface.screen.transition.BaseTransition;
import de.verygame.surface.util.modifier.SingleValueModifier;
import de.verygame.surface.util.modifier.base.SimpleModifierCallback;

public abstract class ShiftTransition
extends BaseTransition {
    protected final Shift shift;

    public ShiftTransition(Shift shift, float duration) {
        super(duration);
        this.shift = shift;
    }

    public static class In
    extends ShiftTransition {
        public In() {
            this(1.0f);
        }

        public In(float duration) {
            this(Shift.LEFT, duration);
        }

        public In(Shift shift, float duration) {
            super(shift, duration);
        }

        @Override
        protected void init() {
            this.animationModifier = this.shift == Shift.LEFT ? new SingleValueModifier(this.duration, -this.context.getViewport().getWorldWidth(), 0.0f, new ShiftCallback()) : new SingleValueModifier(this.duration, this.context.getViewport().getWorldWidth(), 0.0f, new ShiftCallback());
        }
    }

    public static class Out
    extends ShiftTransition {
        public Out() {
            this(1.0f);
        }

        public Out(float duration) {
            this(Shift.LEFT, duration);
        }

        public Out(Shift shift, float duration) {
            super(shift, duration);
        }

        @Override
        protected void init() {
            this.animationModifier = this.shift == Shift.LEFT ? new SingleValueModifier(this.duration, 0.0f, -this.context.getViewport().getWorldWidth(), new ShiftCallback()) : new SingleValueModifier(this.duration, 0.0f, this.context.getViewport().getWorldWidth(), new ShiftCallback());
        }
    }

    private class ShiftCallback
    extends SimpleModifierCallback {
        private ShiftCallback() {
        }

        @Override
        protected void action(float value) {
            ShiftTransition.this.context.getBatch().getProjectionMatrix().translate(value, 0.0f, 0.0f);
        }
    }

    public static enum Shift {
        LEFT,
        RIGHT;

    }
}

