/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;

public class FontUtils {
    private static final FontParameterBuilder builder = new FontParameterBuilder();

    private FontUtils() {
    }

    public static FontParameterBuilder obtainParameterBuilder() {
        return builder;
    }

    public static class FontParameterBuilder {
        FreeTypeFontGenerator.FreeTypeFontParameter para = new FreeTypeFontGenerator.FreeTypeFontParameter();

        public FontParameterBuilder size(int size) {
            this.para.size = size;
            return this;
        }

        public FontParameterBuilder borderColor(float r, float g, float b, float a) {
            return this.borderColor(new Color(r, g, b, a));
        }

        public FontParameterBuilder borderColor(Color color) {
            this.para.borderColor = color;
            return this;
        }

        public FontParameterBuilder borderWidth(float width) {
            this.para.borderWidth = width;
            return this;
        }

        public FontParameterBuilder character(String chars) {
            this.para.characters = chars;
            return this;
        }

        public FontParameterBuilder minFilter(Texture.TextureFilter filter) {
            this.para.minFilter = filter;
            return this;
        }

        public FontParameterBuilder magFilter(Texture.TextureFilter filter) {
            this.para.magFilter = filter;
            return this;
        }

        public FreeTypeFontGenerator.FreeTypeFontParameter build() {
            FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
            parameter.magFilter = this.para.magFilter;
            parameter.minFilter = this.para.minFilter;
            parameter.characters = this.para.characters;
            parameter.borderWidth = this.para.borderWidth;
            parameter.borderColor = this.para.borderColor;
            parameter.size = this.para.size;
            return parameter;
        }
    }
}

