/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.util.modifier.base;

import com.badlogic.gdx.Gdx;
import de.verygame.surface.util.modifier.base.FinishListener;
import de.verygame.surface.util.modifier.base.Modifier;
import de.verygame.surface.util.modifier.base.ModifierCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModifier
implements Modifier {
    protected final float duration;
    protected float currentDuration;
    protected final ModifierCallback target;
    protected boolean finished = false;
    protected List<FinishListener> finishListenerList;

    public AbstractModifier(ModifierCallback target, float duration) {
        this.duration = duration;
        this.currentDuration = duration;
        this.target = target;
        this.finishListenerList = new ArrayList<FinishListener>();
    }

    @Override
    public void update() {
        this.currentDuration -= Gdx.graphics.getDeltaTime();
        if (this.currentDuration > 0.0f) {
            this.tick();
        } else if (!this.finished) {
            this.currentDuration = 0.0f;
            this.tick();
            this.finished = true;
        }
    }

    @Override
    public void addFinishListener(FinishListener finishListener) {
        this.finishListenerList.add(finishListener);
    }

    @Override
    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public void onFinish() {
        for (int i = 0; i < this.finishListenerList.size(); ++i) {
            this.finishListenerList.get(i).onFinish();
        }
    }

    @Override
    public void kill() {
        this.finished = true;
    }

    @Override
    public void reset() {
        this.finished = false;
        this.currentDuration = this.duration;
    }
}

