/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;

public class FPSOverlay {
    private static final Color color = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    private static final float TTD = 3.0f;
    private BitmapFont bitmapFont = new BitmapFont();
    private CharSequence display;
    private float remainingTTD = 3.0f;
    private float x;
    private float y;

    public FPSOverlay() {
        this.bitmapFont.setColor(color);
        this.bitmapFont.getData().setScale((float)Gdx.graphics.getHeight() / 600.0f, (float)Gdx.graphics.getHeight() / 600.0f);
        this.x = 5.0f * Gdx.graphics.getDensity();
        this.y = 3.0f * Gdx.graphics.getDensity() + 15.0f * this.bitmapFont.getScaleX();
        this.update();
    }

    public void update() {
        this.display = String.valueOf(Gdx.graphics.getFramesPerSecond());
    }

    public void render(Batch batch) {
        this.remainingTTD -= Gdx.graphics.getDeltaTime();
        if (this.remainingTTD <= 0.0f) {
            this.update();
            this.remainingTTD = 3.0f;
        }
        this.bitmapFont.draw(batch, this.display, this.x, this.y);
    }
}

