/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface;

import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Settings {
    private final boolean isDebug;
    private final Viewport viewport;
    private final List<Class<? extends Resource>> resourceClasses = new ArrayList<Class<? extends Resource>>();
    private final List<Class<? extends ResourceUnit>> resourceUnitClasses = new ArrayList<Class<? extends ResourceUnit>>();

    public Settings() {
        this(false);
    }

    public Settings(boolean isDebug) {
        this(isDebug, (Viewport)new ScreenViewport());
    }

    public Settings(boolean isDebug, Viewport viewport) {
        this.isDebug = isDebug;
        this.viewport = viewport;
    }

    public void addResourceClass(Class<? extends Resource> ... classes) {
        Collections.addAll(this.resourceClasses, classes);
    }

    public void addResourceUnitClass(Class<? extends ResourceUnit> ... classes) {
        Collections.addAll(this.resourceUnitClasses, classes);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public List<Class<? extends Resource>> getResourceClasses() {
        return this.resourceClasses;
    }

    public List<Class<? extends ResourceUnit>> getResourceUnitClasses() {
        return this.resourceUnitClasses;
    }
}

