/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.resource;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.I18NBundleLoader;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.ObjectMap;
import de.verygame.surface.event.Event;
import de.verygame.surface.event.EventHandler;
import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceType;
import de.verygame.surface.resource.ResourceUnit;
import de.verygame.surface.resource.ResourceUnitType;
import de.verygame.surface.resource.loader.StringLoader;
import de.verygame.surface.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ResourceHandler
extends EventHandler
implements Disposable {
    private final AssetManager assetManager;
    private final Map<ResourceType, List<String>> pathMap = new EnumMap<ResourceType, List<String>>(ResourceType.class);
    private final Map<ResourceUnit, TextureRegion> regionMap = new HashMap<ResourceUnit, TextureRegion>();
    private final Map<ResourceUnit, BitmapFont> fontMap = new HashMap<ResourceUnit, BitmapFont>();
    private final Map<Resource, IntMap<BitmapFont>> anonFontCache = new HashMap<Resource, IntMap<BitmapFont>>();
    private final Map<BitmapFont, Integer> anonFontReferenceCounter = new HashMap<BitmapFont, Integer>();

    public ResourceHandler() {
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        this.assetManager = new AssetManager((FileHandleResolver)resolver);
        this.initAssetManager((FileHandleResolver)resolver);
        this.initMap();
    }

    private void initMap() {
        ResourceType[] types;
        for (ResourceType type : types = ResourceType.values()) {
            this.pathMap.put(type, new ArrayList());
        }
    }

    private void initAssetManager(FileHandleResolver resolver) {
        this.assetManager.setLoader(String.class, (AssetLoader)new StringLoader(resolver));
        this.assetManager.setLoader(FreeTypeFontGenerator.class, (AssetLoader)new FreeTypeFontGeneratorLoader(resolver));
    }

    public void loadParticleEffect(Resource particleEffect, Resource atlas) {
        if (particleEffect.getType() != ResourceType.PARTICLE_EFFECT) {
            throw new IllegalArgumentException("You are only allowed to load particle-effects with this method!");
        }
        String path = FileUtils.toPath(particleEffect.getType().toString(), particleEffect.getFilePath());
        String pathToAtlas = FileUtils.toPath(atlas.getType().toString(), atlas.getFilePath());
        ParticleEffectLoader.ParticleEffectParameter para = new ParticleEffectLoader.ParticleEffectParameter();
        para.atlasFile = pathToAtlas;
        this.assetManager.load(path, ParticleEffect.class, (AssetLoaderParameters)para);
    }

    public void loadResource(Resource ... resources) {
        for (Resource res : resources) {
            String path = FileUtils.toPath(res.getType().toString(), res.getFilePath());
            this.assetManager.load(path, res.getType().getTarget());
            this.pathMap.get((Object)res.getType()).add(path);
        }
    }

    public void loadResourceExcept(Resource[] resources, Resource ... excludeResources) {
        for (Resource res : resources) {
            boolean skip = false;
            for (Resource ex : excludeResources) {
                if (ex != res) continue;
                skip = true;
            }
            if (skip) continue;
            String path = FileUtils.toPath(res.getType().toString(), res.getFilePath());
            this.assetManager.load(path, res.getType().getTarget());
            this.pathMap.get((Object)res.getType()).add(path);
        }
    }

    public void addResource(ResourceType resourceType, String pathToFile) {
        this.pathMap.get((Object)resourceType).add(pathToFile);
        this.assetManager.load(pathToFile, resourceType.getTarget());
    }

    public void loadLanguage(Locale lang) {
        if (this.pathMap.get((Object)ResourceType.LANG).size() != 1) {
            throw new IllegalStateException("You have to load exactly one language bundle first!");
        }
        String langPath = this.pathMap.get((Object)ResourceType.LANG).get(0);
        this.assetManager.unload(langPath);
        this.assetManager.load(langPath, I18NBundle.class, (AssetLoaderParameters)new I18NBundleLoader.I18NBundleParameter(lang));
        this.emitEvent(Event.OPTION_CHANGED, new Object[0]);
    }

    public String getString(String stringId) {
        if (this.pathMap.get((Object)ResourceType.LANG).size() == 1) {
            return ((I18NBundle)this.assetManager.get(this.pathMap.get((Object)ResourceType.LANG).get(0), I18NBundle.class)).get(stringId);
        }
        throw new IllegalStateException("You have to load exactly one language bundle first!");
    }

    public String getXML(String xmlName) {
        List<String> paths = this.pathMap.get((Object)ResourceType.XML);
        for (String path : paths) {
            String[] splitted = path.split("/");
            if (!splitted[splitted.length - 1].equals(xmlName)) continue;
            return (String)this.assetManager.get(path, String.class);
        }
        return null;
    }

    public TextureRegion getRegion(ResourceUnit region) {
        if (this.regionMap.containsKey(region)) {
            return this.regionMap.get(region);
        }
        if (region.getUnitType() != ResourceUnitType.TEXTURE_REGION) {
            throw new IllegalArgumentException("The given unit have to identify a texture region!");
        }
        if (this.pathMap.containsKey((Object)region.getParent().getType())) {
            List<String> paths = this.pathMap.get((Object)region.getParent().getType());
            for (int i = 0; i < paths.size(); ++i) {
                String path = paths.get(i);
                TextureAtlas atlas = (TextureAtlas)this.assetManager.get(path, TextureAtlas.class);
                TextureAtlas.AtlasRegion tex = atlas.findRegion(region.getIdentifier());
                if (tex == null) continue;
                this.regionMap.put(region, (TextureRegion)tex);
                return tex;
            }
        }
        return null;
    }

    public String getXML(Resource xmlResource) {
        if (xmlResource.getType() != ResourceType.XML) {
            throw new IllegalArgumentException("Wrong type!");
        }
        return this.get(xmlResource, String.class);
    }

    public InputStream getXMLAsStream(Resource xmlResource) {
        return new ByteArrayInputStream(this.getXML(xmlResource).getBytes(Charset.forName("UTF-8")));
    }

    public BitmapFont createFont(ResourceUnit freeTypeFont, FreeTypeFontGenerator.FreeTypeFontParameter parameter) {
        if (freeTypeFont.getUnitType() == ResourceUnitType.BITMAP_FONT) {
            if (this.fontMap.containsKey(freeTypeFont)) {
                this.fontMap.get(freeTypeFont).dispose();
            }
            FreeTypeFontGenerator font = this.get(freeTypeFont.getParent(), FreeTypeFontGenerator.class);
            BitmapFont bFont = font.generateFont(parameter);
            this.fontMap.put(freeTypeFont, bFont);
            return bFont;
        }
        throw new IllegalArgumentException("The resource have to be a font.");
    }

    public void increaseCachedFontReferenceCount(BitmapFont font) {
        if (!this.anonFontReferenceCounter.containsKey(font)) {
            return;
        }
        int references = this.anonFontReferenceCounter.get(font);
        this.anonFontReferenceCounter.put(font, references + 1);
    }

    public boolean destroyCachedFont(BitmapFont font) {
        if (!this.anonFontReferenceCounter.containsKey(font)) {
            return false;
        }
        int references = this.anonFontReferenceCounter.get(font);
        if (references == 1) {
            this.anonFontReferenceCounter.remove(font);
            for (Map.Entry<Resource, IntMap<BitmapFont>> entry : this.anonFontCache.entrySet()) {
                int key = entry.getValue().findKey((Object)font, true, -1);
                if (key == -1) continue;
                entry.getValue().remove(key);
            }
            font.dispose();
        } else {
            this.anonFontReferenceCounter.put(font, references - 1);
        }
        return true;
    }

    public BitmapFont createCachedFont(Resource freeTypeFont, FreeTypeFontGenerator.FreeTypeFontParameter parameter) {
        if (freeTypeFont.getType() == ResourceType.FONT) {
            IntMap<BitmapFont> resMap;
            if (!this.anonFontCache.containsKey(freeTypeFont)) {
                this.anonFontCache.put(freeTypeFont, (IntMap<BitmapFont>)new IntMap());
            }
            if ((resMap = this.anonFontCache.get(freeTypeFont)).containsKey(parameter.size)) {
                BitmapFont font = (BitmapFont)resMap.get(parameter.size);
                this.anonFontReferenceCounter.put(font, this.anonFontReferenceCounter.get(font) + 1);
                return (BitmapFont)resMap.get(parameter.size);
            }
            BitmapFont font = this.get(freeTypeFont, FreeTypeFontGenerator.class).generateFont(parameter);
            this.anonFontReferenceCounter.put(font, 1);
            resMap.put(parameter.size, (Object)font);
            return font;
        }
        throw new IllegalArgumentException("The resource have to be a font generator!");
    }

    public BitmapFont getFont(ResourceUnit fontUnit) {
        if (this.fontMap.containsKey(fontUnit)) {
            return this.fontMap.get(fontUnit);
        }
        throw new IllegalStateException("You have to create the fontUnit first!");
    }

    public void loadSkin(Resource res, Resource atlas, ResourceUnit fontUnit) {
        ObjectMap oMap = new ObjectMap();
        oMap.put((Object)"default-font", (Object)this.getFont(fontUnit));
        this.loadSkin(res, atlas, (ObjectMap<String, Object>)oMap);
    }

    public void loadSkin(Resource res, Resource atlas, ObjectMap<String, Object> oMap) {
        if (res.getType() != ResourceType.SKIN || atlas.getType() != ResourceType.TEX_ATLAS) {
            throw new IllegalArgumentException("Wrong type!");
        }
        String atlasPath = FileUtils.toPath(atlas.getType().getRoot(), atlas.getFilePath());
        this.assetManager.load(FileUtils.toPath(res.getType().toString(), res.getFilePath()), Skin.class, (AssetLoaderParameters)new SkinLoader.SkinParameter(atlasPath, oMap));
        this.pathMap.get((Object)atlas.getType()).add(atlasPath);
    }

    public void scaleNinePatchesIn(Resource skinRes, float scale) {
        Skin ta = this.get(skinRes, Skin.class);
        ObjectMap patches = ta.getAll(NinePatch.class);
        for (ObjectMap.Entry entry : patches) {
            ((NinePatch)entry.value).scale(scale, scale);
        }
    }

    public <T> T get(Resource res, Class<T> type) {
        return (T)this.assetManager.get(FileUtils.toPath(res.getType().toString(), res.getFilePath()), type);
    }

    public <T> T get(String res, Class<T> type) {
        return (T)this.assetManager.get(res, type);
    }

    public boolean update() {
        return this.assetManager.update();
    }

    public float getProgress() {
        return this.assetManager.getProgress();
    }

    public void waitForAssets() {
        this.assetManager.finishLoading();
    }

    public void waitFor(Resource resource) {
        this.assetManager.finishLoadingAsset(FileUtils.toPath(resource.getType().toString(), resource.getFilePath()));
    }

    public void dispose() {
        this.assetManager.dispose();
    }
}

