/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import de.verygame.surface.scene2d.widget.Panel;
import de.verygame.surface.util.modifier.SingleValueModifier;
import de.verygame.surface.util.modifier.base.Modifier;
import de.verygame.surface.util.modifier.base.SimpleModifierCallback;

public class Switch
extends Panel {
    private static final float STD_TIMER = 0.3f;
    private static final float ANIMATION_DURATION = 0.1f;
    private static final float BUTTON_HEIGHT_MUL = 1.25f;
    private static final float UNUSED_CONTENT_WIDTH = 4.0f;
    protected Image switchSprite;
    protected Image stateRect;
    protected SwitchState state = SwitchState.OFF;
    protected LogicalState inputState = LogicalState.NO_ACTION;
    protected Modifier animationModifier;
    protected float borderValueLeft = 0.0f;
    protected float borderValueRight = 0.0f;
    protected float borderValue = 2.0f;
    private float switchTimer = 0.3f;
    private boolean lock = false;

    public Switch(Skin skin, Drawable background) {
        this((SwitchStyle)skin.get(SwitchStyle.class), background);
    }

    public Switch(SwitchStyle style, Drawable background) {
        this(style.getBg(), style.getButton(), background, style.getStateColor());
    }

    public Switch(Drawable background, Drawable button, Drawable whitePixel, Color state) {
        super(background);
        this.stateRect = new Image(whitePixel);
        this.stateRect.setBounds(this.borderValue, this.getHeight() / 2.0f, 0.0f, this.getWidth() / 2.0f - this.borderValue * 2.0f);
        this.stateRect.setColor(state);
        this.switchSprite = new Image(button);
        this.switchSprite.setZIndex(2);
        this.switchSprite.setBounds(this.borderValueLeft, this.getHeight() / 2.0f, this.getHeight() * 2.0f, this.getHeight() * 2.0f);
        this.addListener((EventListener)new InputHandler());
        this.addActor((Actor)this.stateRect);
        this.addActor((Actor)this.switchSprite);
        this.layout();
    }

    public void updateBackground(Drawable background) {
        this.setBackground(background);
    }

    public void updateButton(Drawable button) {
        this.switchSprite.setDrawable(button);
        this.switchSprite.setZIndex(2);
        this.switchSprite.setBounds(this.borderValueLeft - this.getHeight() * 1.25f / 2.0f, this.getHeight() / 2.0f - this.getHeight() * 1.25f / 2.0f, this.getHeight() * 1.25f, this.getHeight() * 1.25f);
    }

    public void updatePixel(Drawable whitePixel) {
        this.stateRect.setDrawable(whitePixel);
        this.stateRect.setBounds(this.borderValueLeft, this.borderValue, 0.0f, this.getHeight() - this.borderValue * 2.0f);
    }

    public boolean isOn() {
        return this.state == SwitchState.ON;
    }

    protected void setBorderValueRight(float borderValueRight) {
        this.borderValueRight = borderValueRight;
        this.switchToState(this.state);
    }

    protected void setBorderValueLeft(float borderValueLeft) {
        this.borderValueLeft = borderValueLeft;
        this.switchToState(this.state);
    }

    public void switchToState(boolean state) {
        if (state) {
            this.switchToState(SwitchState.ON);
        } else {
            this.switchToState(SwitchState.OFF);
        }
    }

    public void switchToState(SwitchState switchState) {
        if (switchState == this.state) {
            if (switchState == SwitchState.ON) {
                this.state = SwitchState.ON;
                this.switchSprite.setX(this.getWidth() - this.borderValueRight - this.switchSprite.getWidth() / 2.0f);
                this.updateRect();
            } else {
                this.state = SwitchState.OFF;
                this.switchSprite.setX(this.borderValueLeft - this.switchSprite.getWidth() / 2.0f);
                this.updateRect();
            }
            return;
        }
        this.switchState();
    }

    protected void switchState() {
        switch (this.state) {
            case ON: {
                this.state = SwitchState.OFF;
                this.startAnimation(this.switchSprite.getX(), this.borderValueLeft - this.switchSprite.getWidth() / 2.0f);
                this.updateRect();
                break;
            }
            case OFF: {
                this.state = SwitchState.ON;
                this.startAnimation(this.switchSprite.getX(), this.getWidth() - this.switchSprite.getWidth() / 2.0f - this.borderValueRight);
                this.updateRect();
                break;
            }
        }
        this.fire(new Event());
    }

    private void startAnimation(float fromX, float toX) {
        this.animationModifier = new SingleValueModifier(0.1f, fromX, toX, new SimpleModifierCallback(){

            @Override
            public void finish(float value) {
                super.finish(value);
                Switch.this.lock = false;
            }

            @Override
            public void init(float value) {
                super.init(value);
                Switch.this.lock = true;
            }

            @Override
            protected void action(float value) {
                Switch.this.switchSprite.setX(value);
                Switch.this.updateRect();
            }
        });
    }

    private void updateRect() {
        this.stateRect.setWidth(this.switchSprite.getX() + this.switchSprite.getWidth() / 2.0f - this.stateRect.getX());
    }

    private void updateBounds() {
        this.borderValueLeft = this.getWidth() / 4.0f;
        this.borderValueRight = this.getWidth() / 4.0f;
        this.updatePixel(this.stateRect.getDrawable());
        this.updateButton(this.switchSprite.getDrawable());
    }

    public void act(float secondsElapsed) {
        super.act(secondsElapsed);
        if (this.animationModifier != null) {
            this.animationModifier.update();
        }
        if (this.lock) {
            return;
        }
        if (this.switchTimer - secondsElapsed <= 0.0f) {
            if (this.switchSprite.getX() + this.switchSprite.getWidth() / 2.0f >= this.getWidth() / 2.0f) {
                this.switchToState(SwitchState.ON);
            } else if (this.switchSprite.getX() + this.switchSprite.getWidth() / 2.0f < this.getWidth() / 2.0f) {
                this.switchToState(SwitchState.OFF);
            }
        } else {
            this.switchTimer -= secondsElapsed;
        }
    }

    public void setHeight(float height) {
        super.setHeight(height);
        this.updateBounds();
    }

    public void setWidth(float width) {
        super.setWidth(width);
        this.updateBounds();
    }

    public static class SwitchStyle {
        private Drawable bg;
        private Drawable button;
        private Color stateColor;

        public SwitchStyle() {
        }

        public SwitchStyle(Drawable bg, Drawable button, Color stateColor) {
            this.bg = bg;
            this.button = button;
            this.stateColor = stateColor;
        }

        public Drawable getBg() {
            return this.bg;
        }

        public void setBg(Drawable bg) {
            this.bg = bg;
        }

        public Drawable getButton() {
            return this.button;
        }

        public void setButton(Drawable button) {
            this.button = button;
        }

        public Color getStateColor() {
            return this.stateColor;
        }

        public void setStateColor(Color stateColor) {
            this.stateColor = stateColor;
        }
    }

    public static enum SwitchState {
        ON,
        OFF;

    }

    protected static enum LogicalState {
        NO_ACTION,
        PRESSED,
        MOVING;

    }

    protected class InputHandler
    extends InputListener {
        protected InputHandler() {
        }

        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            Switch.this.switchTimer = 0.3f;
            if (Switch.this.lock) {
                return;
            }
            if (LogicalState.MOVING == Switch.this.inputState) {
                Switch.this.inputState = LogicalState.NO_ACTION;
                if (Switch.this.switchSprite.getX() + Switch.this.switchSprite.getWidth() / 2.0f >= Switch.this.getWidth() / 2.0f) {
                    Switch.this.switchToState(SwitchState.ON);
                } else if (Switch.this.switchSprite.getX() + Switch.this.switchSprite.getWidth() / 2.0f < Switch.this.getWidth() / 2.0f) {
                    Switch.this.switchToState(SwitchState.OFF);
                }
            } else if (LogicalState.PRESSED == Switch.this.inputState) {
                Switch.this.switchState();
            }
        }

        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            Switch.this.switchTimer = 0.3f;
            if (Switch.this.lock) {
                return;
            }
            if (x >= Switch.this.borderValueLeft && x <= Switch.this.getWidth() - Switch.this.borderValueRight) {
                Switch.this.switchSprite.setX(x - Switch.this.switchSprite.getWidth() / 2.0f);
                Switch.this.updateRect();
            }
            Switch.this.inputState = LogicalState.MOVING;
        }

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            Switch.this.switchTimer = 0.3f;
            if (Switch.this.lock) {
                return false;
            }
            Switch.this.inputState = LogicalState.PRESSED;
            return true;
        }
    }
}

