/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.xue;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.surface.scene2d.xue.Scene2DMapping;
import de.verygame.xue.GuiXue;
import de.verygame.xue.handler.ElementsTagGroupHandler;
import de.verygame.xue.input.XueInputEvent;
import de.verygame.xue.mapping.GlobalMappings;
import de.verygame.xue.mapping.TagMapping;
import de.verygame.xue.util.action.ActionSequence;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class XueStage
extends Stage {
    private final GuiXue<Actor> xue;

    public XueStage(Batch batch, InputStream resourceFile, ResourceHandler resourceHandler) {
        this(batch, (Viewport)new FitViewport((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight()), resourceFile, resourceHandler);
    }

    public XueStage(Batch batch, Viewport viewport, InputStream resourceFile, ResourceHandler resourceHandler) {
        super(viewport, batch);
        this.xue = new GuiXue((GlobalMappings)new Scene2DMapping(resourceHandler));
        this.xue.addFile(resourceFile, "default");
        this.xue.addLoadTask(new GuiXue.LoadTask(){

            public void postLoad() {
                Set entries = XueStage.this.xue.getDefaultElementMap().entrySet();
                for (Map.Entry entry : entries) {
                    Actor currentElement = (Actor)XueStage.this.xue.getDefaultElementMap().get(entry.getKey());
                    if (currentElement.getParent() != null) continue;
                    XueStage.this.addActor(currentElement);
                }
                XueStage.this.getActors().sort((Comparator)new Comparator<Actor>(){

                    @Override
                    public int compare(Actor o1, Actor o2) {
                        return o1.getZIndex() - o2.getZIndex();
                    }
                });
            }

            public void preLoad() {
            }
        });
    }

    public void addElementMapping(TagMapping<Actor> mapping) {
        this.xue.addMappingUnsafe(ElementsTagGroupHandler.class, mapping);
    }

    public int getElementSize() {
        return this.xue.getElementSize();
    }

    public float calcActionSequenceDeactivationDelay() {
        Map aMap = this.xue.getActionSequenceMap();
        float maxDelay = 0.0f;
        for (Map.Entry entry : aMap.entrySet()) {
            float duration;
            if (((ActionSequence)entry.getValue()).getStartEvent() != XueInputEvent.DEACTIVATE || !((duration = ((ActionSequence)entry.getValue()).getDuration()) > maxDelay)) continue;
            maxDelay = duration;
        }
        return maxDelay;
    }

    public void onInputEvent(XueInputEvent inputEvent) {
        this.xue.onInputEvent(inputEvent);
    }

    public void bind(Object bindTarget) {
        this.xue.bind(bindTarget);
    }

    public Actor getElementByName(String name) {
        return (Actor)this.xue.getElementByName(name);
    }

    public Map<String, Actor> getElementMap() {
        return this.xue.getDefaultElementMap();
    }

    public void load() {
        try {
            this.xue.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void act() {
        super.act();
        this.xue.onUpdate(Gdx.graphics.getDeltaTime());
    }

    public void draw() {
        Camera camera = this.getViewport().getCamera();
        camera.update();
        if (!this.getRoot().isVisible()) {
            return;
        }
        Batch batch = this.getBatch();
        if (batch != null) {
            this.getRoot().draw(batch, 1.0f);
        }
    }
}

