/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.base;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.viewport.Viewport;
import de.verygame.surface.screen.base.Content;
import de.verygame.surface.screen.base.Screen;
import de.verygame.surface.screen.base.ScreenId;
import de.verygame.surface.screen.base.SubScreenContext;
import de.verygame.surface.screen.base.Transition;
import java.util.Map;

public abstract class BaseScreen
implements Screen {
    private static final int T_OUT_INDEX = 0;
    private static final int T_IN_INDEX = 1;
    protected final Content content;
    protected final SubScreenContext context;
    protected Transition[] transition;

    public BaseScreen(Viewport viewport, Content content) {
        this.context = new SubScreenContext(viewport);
        this.content = content;
        this.transition = new Transition[2];
    }

    @Override
    public void setOutTransition(Transition out) {
        this.transition[0] = out;
    }

    @Override
    public void setInTransition(Transition in) {
        this.transition[1] = in;
    }

    @Override
    public void onActivate(ScreenId predecessor) {
        this.context.applyViewport();
        this.context.updateViewport(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.context.onActivate(predecessor);
        this.content.onActivate(predecessor, this.context.getInputHandler());
        if (this.transition[1] != null) {
            this.transition[1].reset(this.context);
        }
    }

    @Override
    public float onDeactivate(ScreenId successor) {
        float delay = this.context.onDeactivate(successor);
        float contentDelay = this.content.onDeactivate(successor, this.context.getInputHandler());
        if (this.transition[0] != null) {
            this.transition[0].reset(this.context);
            return Math.max(Math.max(this.transition[0].getDuration(), delay), contentDelay);
        }
        return Math.max(delay, contentDelay);
    }

    @Override
    public void onAdd(PolygonSpriteBatch batch, InputMultiplexer inputMultiplexer, Map<String, Object> dependencyMap) {
        this.context.setBatch(batch);
        this.context.setInputHandler(inputMultiplexer);
        this.context.setDependencies(dependencyMap);
        this.content.onBind(this.context);
    }

    @Override
    public void onResize(int width, int height) {
        this.content.onResize(width, height);
        this.context.updateViewport(width, height);
        this.context.resizeSubScreen(width, height);
    }

    @Override
    public void onUpdate() {
        this.content.onUpdate();
        this.context.update();
        this.context.getBatch().setProjectionMatrix(this.context.getViewport().getCamera().combined);
    }

    @Override
    public void onRender() {
        for (Transition t : this.transition) {
            if (t == null) continue;
            t.update();
            t.preRender(this.context.getBatch());
        }
        this.content.onRender();
        this.context.renderScreen();
        for (Transition t : this.transition) {
            if (t == null) continue;
            t.postRender(this.context.getBatch());
        }
    }

    @Override
    public void onPause() {
        this.content.onPause();
        this.context.pauseSubScreen();
    }

    @Override
    public void onResume() {
        this.content.onResume();
        this.context.resumeSubScreen();
    }

    public void dispose() {
        this.content.dispose();
        this.context.dispose();
    }

    @Override
    public Content getContent() {
        return this.content;
    }
}

