/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.transition;

import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import de.verygame.surface.screen.base.ScreenContext;
import de.verygame.surface.screen.base.Transition;
import de.verygame.surface.util.modifier.base.Modifier;

public abstract class BaseTransition
implements Transition {
    protected float duration;
    protected Modifier animationModifier;
    protected ScreenContext context;

    public BaseTransition(float duration) {
        this.duration = duration;
    }

    protected abstract void init();

    @Override
    public void preRender(PolygonSpriteBatch batch) {
    }

    @Override
    public void postRender(PolygonSpriteBatch batch) {
    }

    @Override
    public void update() {
        if (this.animationModifier != null) {
            this.animationModifier.update();
        }
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public boolean hasFinished() {
        return this.animationModifier.hasFinished();
    }

    @Override
    public void reset(ScreenContext context) {
        this.context = context;
        if (this.animationModifier != null) {
            this.animationModifier.reset();
        }
        this.init();
    }
}

