/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.transition;

import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import de.verygame.surface.screen.transition.BaseTransition;
import de.verygame.surface.util.modifier.SingleValueModifier;
import de.verygame.surface.util.modifier.base.SimpleModifierCallback;

public abstract class ZoomTransition
extends BaseTransition {
    private float batchScaleX;
    private float batchScaleY;
    private Vector3 translation;
    protected final float zoomFactor;

    public ZoomTransition(float duration, float zoomFactor) {
        super(duration);
        this.zoomFactor = zoomFactor;
    }

    @Override
    protected void init() {
        PolygonSpriteBatch batch = this.context.getBatch();
        this.batchScaleX = batch.getProjectionMatrix().getScaleX();
        this.batchScaleY = batch.getProjectionMatrix().getScaleY();
        this.translation = new Vector3();
        this.translation = batch.getProjectionMatrix().getTranslation(this.translation);
    }

    public static class Out
    extends ZoomTransition {
        public Out(float duration, float zoomFactor) {
            super(duration, zoomFactor);
        }

        @Override
        protected void init() {
            super.init();
            this.animationModifier = new SingleValueModifier(this.duration, this.zoomFactor, 1.0f, new ZoomCallback());
        }
    }

    public static class In
    extends ZoomTransition {
        public In(float duration, float zoomFactor) {
            super(duration, zoomFactor);
        }

        @Override
        protected void init() {
            super.init();
            this.animationModifier = new SingleValueModifier(this.duration, 1.0f, this.zoomFactor, new ZoomCallback());
        }
    }

    private class ZoomCallback
    extends SimpleModifierCallback {
        private ZoomCallback() {
        }

        @Override
        protected void action(float value) {
            Matrix4 mat = ZoomTransition.this.context.getBatch().getProjectionMatrix();
            float worldWidth = ZoomTransition.this.context.getViewport().getWorldWidth();
            float worldHeight = ZoomTransition.this.context.getViewport().getWorldHeight();
            float oldScaleX = mat.getScaleX();
            float oldScaleY = mat.getScaleY();
            mat.setTranslation(((ZoomTransition)ZoomTransition.this).translation.x, ((ZoomTransition)ZoomTransition.this).translation.y, 0.0f);
            mat.translate(-(value * worldWidth - worldWidth) / 2.0f, -(value * worldHeight - worldHeight) / 2.0f, 0.0f);
            mat.scale(1.0f / oldScaleX, 1.0f / oldScaleY, 1.0f);
            mat.scale(ZoomTransition.this.batchScaleX * value, ZoomTransition.this.batchScaleY * value, 1.0f);
        }
    }
}

