/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.util.modifier;

import de.verygame.surface.util.math.function.EaseFunction;
import de.verygame.surface.util.math.function.LinearEaseFunction;
import de.verygame.surface.util.modifier.base.AbstractModifier;
import de.verygame.surface.util.modifier.base.ModifierCallback;

public class SingleValueModifier
extends AbstractModifier {
    protected final float fromValue;
    protected final float toValue;
    protected final EaseFunction easeFunction;

    public SingleValueModifier(float duration, float fromValue, float toValue, ModifierCallback target) {
        this(duration, fromValue, toValue, LinearEaseFunction.getInstance(), target);
    }

    public SingleValueModifier(float duration, float fromValue, float toValue, EaseFunction easeFunction, ModifierCallback target) {
        super(target, duration);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.easeFunction = easeFunction;
    }

    @Override
    public void tick() {
        if (this.fromValue >= this.toValue) {
            this.target.call(this.easeFunction.getPercentage(this.currentDuration, this.duration) * Math.abs(this.toValue - this.fromValue) + this.toValue);
        } else {
            this.target.call(this.easeFunction.getPercentage(this.duration - this.currentDuration, this.duration) * Math.abs(this.toValue - this.fromValue) + this.fromValue);
        }
    }

    @Override
    public void onFinish() {
        super.onFinish();
        this.target.finish(this.toValue);
    }

    @Override
    public void onInit() {
        this.target.init(this.fromValue);
    }
}

