/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.event;

import de.verygame.surface.event.Event;
import de.verygame.surface.event.EventListener;
import de.verygame.surface.event.EventRoute;
import de.verygame.surface.event.EventRouteListener;
import de.verygame.surface.event.EventType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler {
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private final Map<EventRouteListener, List<EventType>> eventHandlerMap = new HashMap<EventRouteListener, List<EventType>>();
    private final Map<EventRouteListener, Map<Event, Method>> cache = new HashMap<EventRouteListener, Map<Event, Method>>();

    public void register(EventType eventType, EventRouteListener eventListener) {
        this.register(eventListener, eventType);
    }

    public void register(EventRouteListener eventListener, EventType ... type) {
        if (this.eventHandlerMap.containsKey(eventListener)) {
            Collections.addAll((Collection)this.eventHandlerMap.get(eventListener), type);
        } else {
            ArrayList list = new ArrayList(EventType.values().length);
            Collections.addAll(list, type);
            this.eventHandlerMap.put(eventListener, list);
        }
    }

    public void unregister(EventListener eventListener, EventType ... type) {
        if (this.eventHandlerMap.containsKey(eventListener)) {
            List<EventType> list = this.eventHandlerMap.get(eventListener);
            if (list.size() == 1) {
                this.eventHandlerMap.remove(eventListener);
            } else {
                for (EventType aType : type) {
                    list.remove((Object)aType);
                }
            }
        }
    }

    public boolean isRegistered(EventListener eventListener, EventType eventType) {
        return this.eventHandlerMap.containsKey(eventListener) && this.eventHandlerMap.get(eventListener).contains((Object)eventType);
    }

    public void emitEvent(Event event, Object ... attachedObjects) {
        for (Map.Entry<EventRouteListener, List<EventType>> entry : this.eventHandlerMap.entrySet()) {
            EventRouteListener eventListener = entry.getKey();
            boolean sendEvent = entry.getValue().contains((Object)event.getType());
            if (!sendEvent || this.emitReflectionEvent(eventListener, event, attachedObjects) || !(eventListener instanceof EventListener)) continue;
            ((EventListener)eventListener).handleEvent(event, attachedObjects);
        }
    }

    private boolean emitReflectionEvent(EventRouteListener target, Event event, Object ... attached) {
        if (this.cache.containsKey(target)) {
            Map<Event, Method> methodMap = this.cache.get(target);
            if (methodMap.containsKey(event)) {
                Method method = methodMap.get(event);
                try {
                    method.invoke((Object)target, attached);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.printReflectionError(e);
                    return false;
                }
            }
        } else {
            this.cache.put(target, new HashMap());
        }
        for (Method method : target.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventRoute.class) || method.getAnnotation(EventRoute.class).value() != event.getId()) continue;
            try {
                method.setAccessible(true);
                method.invoke((Object)target, attached);
                this.cache.get(target).put(event, method);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.printReflectionError(e);
            }
        }
        return false;
    }

    private void printReflectionError(Exception e) {
        log.error("An " + e.getClass().getSimpleName() + " has occurred. Reason: " + e.getMessage(), (Throwable)e);
    }
}

