/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.scene2d.xue;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.util.math.CoordinateType;
import de.verygame.xue.mapping.GlobalMappings;

public class Scene2DMapping
implements GlobalMappings<Actor> {
    private final ResourceHandler resourceHandler;

    public Scene2DMapping(ResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    public float calcFromRelativeValue(Actor target, float value, CoordinateType coordFlag) {
        if (coordFlag == CoordinateType.X) {
            if (target.getParent() == null) {
                return 0.01f * (float)Gdx.graphics.getWidth() * value;
            }
            return 0.01f * target.getParent().getWidth() * value;
        }
        if (coordFlag == CoordinateType.Y) {
            if (target.getParent() == null) {
                return 0.01f * (float)Gdx.graphics.getHeight() * value;
            }
            return 0.01f * target.getParent().getHeight() * value;
        }
        return -1.0f;
    }

    public String getString(String key) {
        return this.resourceHandler.getString(key);
    }

    public float getDensity() {
        return Gdx.graphics.getDensity();
    }
}

