/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.g2d.Batch;
import de.verygame.surface.annotation.Dependency;
import de.verygame.surface.event.EventHandler;
import de.verygame.surface.resource.Resource;
import de.verygame.surface.resource.ResourceHandler;
import de.verygame.surface.scene2d.xue.ElementMapping;
import de.verygame.surface.scene2d.xue.XueStage;
import de.verygame.surface.screen.base.Content;
import de.verygame.surface.screen.base.ScreenContext;
import de.verygame.surface.screen.base.ScreenId;
import de.verygame.xue.input.XueInputEvent;

public abstract class StageContent
extends EventHandler
implements Content {
    @Dependency
    protected ResourceHandler resourceHandler;
    protected XueStage stage;
    protected ScreenContext context;

    protected abstract Resource defineXML();

    protected abstract Resource defineSkin();

    protected void preLoad() {
    }

    protected void postLoad() {
    }

    @Override
    public void onBind(ScreenContext context) {
        this.context = context;
        this.stage = new XueStage((Batch)context.getBatch(), context.getViewport(), this.resourceHandler.getXMLAsStream(this.defineXML()), this.resourceHandler);
        this.stage.addElementMapping(new ElementMapping(this.resourceHandler, this.defineSkin()));
        this.stage.bind(this);
        this.preLoad();
        this.stage.load();
        this.postLoad();
    }

    @Override
    public void onActivate(ScreenId predecessor, InputMultiplexer inputMultiplexer) {
        inputMultiplexer.addProcessor((InputProcessor)this.stage);
        this.onResize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.stage.onInputEvent(XueInputEvent.ACTIVATE);
    }

    @Override
    public float onDeactivate(ScreenId successor, InputMultiplexer inputMultiplexer) {
        inputMultiplexer.removeProcessor((InputProcessor)this.stage);
        this.stage.onInputEvent(XueInputEvent.DEACTIVATE);
        return this.stage.calcActionSequenceDeactivationDelay();
    }

    @Override
    public void onUpdate() {
        this.stage.act();
    }

    @Override
    public void onRender() {
        this.stage.draw();
    }

    public void dispose() {
        this.stage.dispose();
    }

    @Override
    public void onResize(int width, int height) {
        this.stage.getRoot().setBounds(0.0f, 0.0f, (float)width, (float)height);
        this.stage.onInputEvent(XueInputEvent.RESIZE);
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }
}

