/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.base;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import de.verygame.surface.annotation.Dependency;
import de.verygame.surface.screen.base.Content;
import de.verygame.surface.screen.base.DependencyMissingException;
import de.verygame.surface.screen.base.Screen;
import de.verygame.surface.screen.base.ScreenId;
import de.verygame.surface.util.ReflectionUtils;
import de.verygame.surface.util.task.DelayedTask;
import de.verygame.surface.util.task.Task;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScreenSwitch {
    private final Map<ScreenId, Screen> screenMap = new HashMap<ScreenId, Screen>();
    private Map<String, Object> dependencyMap = new HashMap<String, Object>();
    private Screen activeScreen;
    private DelayedTask currentTask;
    private PolygonSpriteBatch batch;
    private InputMultiplexer inputMultiplexer;

    public void setBatch(PolygonSpriteBatch batch) {
        this.batch = batch;
    }

    public void setInputHandler(InputMultiplexer inputMultiplexer) {
        this.inputMultiplexer = inputMultiplexer;
    }

    public InputMultiplexer getInputHandler() {
        return this.inputMultiplexer;
    }

    public PolygonSpriteBatch getBatch() {
        return this.batch;
    }

    public void addScreen(ScreenId id, Screen screen) {
        try {
            this.injectDependencies(screen.getContent());
            this.screenMap.put(id, screen);
            screen.onAdd(this.batch, this.inputMultiplexer, this.dependencyMap);
        }
        catch (DependencyMissingException e) {
            Gdx.app.debug("ScreenSwitch", e.getMessage(), (Throwable)e);
        }
    }

    private void injectDependencies(Content content) throws DependencyMissingException {
        List<Field> fields = ReflectionUtils.getAllFields(content.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Dependency.class)) continue;
            field.setAccessible(true);
            String fieldName = field.getName();
            if (this.dependencyMap.containsKey(fieldName)) {
                Object value = this.dependencyMap.get(fieldName);
                try {
                    field.set(content, value);
                }
                catch (IllegalAccessException e) {
                    Gdx.app.debug("Field", e.getMessage(), (Throwable)e);
                }
                continue;
            }
            throw new DependencyMissingException(fieldName, field.getType());
        }
    }

    public void setScreenSimple(ScreenId id) {
        if (!this.screenMap.containsKey(id)) {
            throw new IllegalArgumentException("The screen is not registered!");
        }
        this.activeScreen = this.screenMap.get(id);
    }

    public void setActive(ScreenId id) {
        if (id == null) {
            if (this.activeScreen != null) {
                this.deactivateScreen(null, null);
            }
            return;
        }
        if (!this.screenMap.containsKey(id)) {
            throw new IllegalArgumentException("The screen is not registered!");
        }
        this.setActive(id, this.screenMap.get(id));
    }

    private void setActive(ScreenId key, Screen screen) {
        if (this.currentTask != null) {
            throw new IllegalStateException("A task is still active.");
        }
        if (this.activeScreen == null) {
            screen.onActivate(null);
            this.activeScreen = screen;
            return;
        }
        this.deactivateScreen(key, screen);
    }

    private void deactivateScreen(ScreenId key, final Screen screen) {
        float delay = this.activeScreen.onDeactivate(key);
        if (delay <= 0.0f) {
            if (screen != null) {
                screen.onActivate(this.getActiveScreenId());
            }
            this.activeScreen = screen;
        } else {
            this.currentTask = new DelayedTask(delay, new Task(){

                @Override
                public void work() {
                    if (screen != null) {
                        screen.onActivate(ScreenSwitch.this.getActiveScreenId());
                    }
                    ScreenSwitch.this.activeScreen = screen;
                }
            });
        }
    }

    public Screen getActiveScreen() {
        return this.activeScreen;
    }

    public ScreenId getActiveScreenId() {
        for (Map.Entry<ScreenId, Screen> entry : this.screenMap.entrySet()) {
            if (entry.getValue() != this.activeScreen) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean containsScreen(ScreenId id) {
        return this.screenMap.containsKey(id);
    }

    public void updateSwitch() {
        if (this.activeScreen == null) {
            return;
        }
        if (this.currentTask != null) {
            this.currentTask.update(Gdx.graphics.getDeltaTime());
            this.currentTask = this.currentTask.hasFinished() ? null : this.currentTask;
        }
    }

    public void updateScreen() {
        if (this.activeScreen != null) {
            this.activeScreen.onUpdate();
        }
    }

    public void renderScreen() {
        if (this.activeScreen != null) {
            this.activeScreen.onRender();
        }
    }

    public void resize(int width, int height) {
        if (this.activeScreen != null) {
            this.activeScreen.onResize(width, height);
        }
    }

    public void pause() {
        Set<Map.Entry<ScreenId, Screen>> entries = this.screenMap.entrySet();
        for (Map.Entry<ScreenId, Screen> entry : entries) {
            entry.getValue().onPause();
        }
    }

    public void resume() {
        Set<Map.Entry<ScreenId, Screen>> entries = this.screenMap.entrySet();
        for (Map.Entry<ScreenId, Screen> entry : entries) {
            entry.getValue().onResume();
        }
    }

    public void dispose() {
        Set<Map.Entry<ScreenId, Screen>> entries = this.screenMap.entrySet();
        for (Map.Entry<ScreenId, Screen> entry : entries) {
            entry.getValue().dispose();
        }
    }

    public void addDependency(String id, Object dependency) {
        this.dependencyMap.put(id, dependency);
    }

    public void setDependencyMap(Map<String, Object> dependencyMap) {
        this.dependencyMap = dependencyMap;
    }
}

