/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.screen.base;

import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.viewport.Viewport;
import de.verygame.surface.screen.base.ScreenContext;
import de.verygame.surface.screen.base.ScreenId;
import de.verygame.surface.screen.base.ScreenSwitch;
import de.verygame.surface.screen.base.SubScreen;
import de.verygame.surface.screen.base.SubScreenId;
import java.util.Map;

public class SubScreenContext
implements ScreenContext {
    protected final ScreenSwitch screenSwitch;
    protected final Viewport viewport;
    protected boolean showSubScreen = false;

    public SubScreenContext(Viewport viewport) {
        this.viewport = viewport;
        this.screenSwitch = new ScreenSwitch();
    }

    public void setDependencies(Map<String, Object> dependencies) {
        this.screenSwitch.setDependencyMap(dependencies);
    }

    public void setBatch(PolygonSpriteBatch polygonSpriteBatch) {
        this.screenSwitch.setBatch(polygonSpriteBatch);
    }

    public void setInputHandler(InputMultiplexer inputHandler) {
        this.screenSwitch.setInputHandler(inputHandler);
    }

    public InputMultiplexer getInputHandler() {
        return this.screenSwitch.getInputHandler();
    }

    public void onActivate(ScreenId screenKey) {
        if (this.screenSwitch.getActiveScreen() != null) {
            this.screenSwitch.getActiveScreen().onActivate(screenKey);
        }
    }

    public float onDeactivate(ScreenId screenKey) {
        if (this.screenSwitch.getActiveScreen() != null) {
            return this.screenSwitch.getActiveScreen().onDeactivate(screenKey);
        }
        return 0.0f;
    }

    public void applyViewport() {
        this.viewport.apply(true);
    }

    public void updateViewport(int width, int height) {
        this.viewport.update(width, height, true);
    }

    public void update() {
        this.screenSwitch.updateSwitch();
        this.screenSwitch.updateScreen();
    }

    public void renderScreen() {
        if (this.showSubScreen) {
            this.screenSwitch.renderScreen();
        }
    }

    public void resizeSubScreen(int width, int height) {
        this.screenSwitch.resize(width, height);
    }

    public void pauseSubScreen() {
        this.screenSwitch.pause();
    }

    public void resumeSubScreen() {
        this.screenSwitch.resume();
    }

    public void dispose() {
        this.screenSwitch.dispose();
    }

    @Override
    public Viewport getViewport() {
        return this.viewport;
    }

    @Override
    public PolygonSpriteBatch getBatch() {
        return this.screenSwitch.getBatch();
    }

    @Override
    public void addSubScreen(SubScreenId id, SubScreen subScreen) {
        if (this.screenSwitch.getBatch() == null) {
            throw new IllegalStateException("Parent screen have to be attached to a screen switch!");
        }
        this.screenSwitch.addScreen(id, subScreen);
    }

    @Override
    public SubScreen getActiveSubScreen() {
        return (SubScreen)this.screenSwitch.getActiveScreen();
    }

    @Override
    public void showScreen(SubScreenId id) {
        this.showSubScreen = true;
        this.screenSwitch.setActive(id);
    }

    @Override
    public void initialize(SubScreenId id) {
        this.showSubScreen = true;
        this.screenSwitch.setScreenSimple(id);
    }

    @Override
    public void hideScreen() {
        this.showSubScreen = false;
    }
}

