/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.util;

import com.badlogic.gdx.graphics.Color;

public class ColorUtils {
    private static final int HEX_START_INDEX = 1;
    private static final int HEX_FIRST_DIVIDER = 3;
    private static final int HEX_SECOND_DIVIDER = 5;
    private static final int HEX_END_INDEX = 7;
    private static final int HEX_RADIX = 16;
    private static final float RGB_RANGE = 255.0f;

    private ColorUtils() {
    }

    public static Color fromHex(String hex) {
        if (hex.length() != 7 || !hex.startsWith("#")) {
            throw new IllegalArgumentException("The argument have to a valid hex color code!");
        }
        int r = Integer.parseInt(hex.substring(1, 3), 16);
        int g = Integer.parseInt(hex.substring(3, 5), 16);
        int b = Integer.parseInt(hex.substring(5, 7), 16);
        return new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }
}

