/*
 * Decompiled with CFR 0.152.
 */
package de.verygame.surface.util.task;

import com.badlogic.gdx.Gdx;
import de.verygame.surface.util.task.StepTask;

public class LoopedTask {
    private final StepTask task;
    private final float duration;
    private float timeLeft;

    public LoopedTask(float duration, StepTask task) {
        this.task = task;
        this.duration = duration;
        this.timeLeft = duration;
        this.task.init(duration);
    }

    public void update() {
        float timePassed = Gdx.graphics.getDeltaTime();
        if (this.timeLeft > 0.0f) {
            this.task.work(timePassed);
            this.timeLeft -= timePassed;
        }
    }

    public void kill() {
        this.timeLeft = 0.0f;
    }

    public boolean hasFinished() {
        return this.timeLeft <= 0.0f;
    }

    public float getDuration() {
        return this.duration;
    }

    public void reset() {
        this.reset(this.duration);
    }

    public void reset(float newDuration) {
        this.timeLeft = newDuration;
        this.task.init(newDuration);
    }
}

