/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.annomark.example.model;

import com.agimatec.annomark.example.model.Privilege;
import com.agimatec.annomark.example.model.UserCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="role")
public class Role
implements Serializable {
    private long roleId;
    private int version;
    private String roleName;
    private String roleDescription;
    private List<UserCore> userCores = new ArrayList<UserCore>(0);
    private List<Privilege> privileges = new ArrayList<Privilege>(0);

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="role_id", unique=true, nullable=false)
    public long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(long roleId) {
        this.roleId = roleId;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Column(name="role_name", length=40, unique=true, nullable=false)
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Column(name="role_description")
    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="role")
    public List<UserCore> getUserCores() {
        return this.userCores;
    }

    public void setUserCores(List<UserCore> userCores) {
        this.userCores = userCores;
    }

    @ManyToMany
    @JoinTable(name="Role_Privilege", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="privilege_id")})
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public void addPrivilege(Privilege aTarget) {
        this.privileges.add(aTarget);
    }

    public void removePrivilege(Privilege aTarget) {
        this.privileges.remove(aTarget);
    }

    public String toString() {
        return "Role{roleId=" + this.roleId + ", roleName='" + this.roleName + '\'' + '}';
    }
}

