/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.beans;

import com.agimatec.commons.beans.QueryOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class MapQuery
implements Serializable {
    private List transformations = new ArrayList();

    public MapQuery(String queryExpression) {
        this.parse(queryExpression);
    }

    public MapQuery() {
    }

    private void add(QueryOperation trans) {
        this.transformations.add(trans);
    }

    private void addOp(String op) {
        this.transformations.add(op);
    }

    public void parse(String queryExpression) {
        this.parse(new StringTokenizer(queryExpression, "\t &|!=", true));
    }

    public void parse(StringTokenizer tokens) {
        this.reset();
        while (true) {
            QueryOperation qop = new QueryOperation();
            this.add(qop);
            qop.queryAttr = this.nextNonBlank(tokens);
            qop.operator = this.checkOperator(tokens, "");
            qop.queryValue = this.nextNonBlank(tokens);
            String logical = this.nextNonBlank(tokens);
            if (logical == null) break;
            if ("&".equals(logical)) {
                this.addOp(logical);
                continue;
            }
            if (!"|".equals(logical)) continue;
            this.addOp(logical);
        }
    }

    private void reset() {
        if (this.transformations == null) {
            this.transformations = new ArrayList();
        } else {
            this.transformations.clear();
        }
    }

    private String nextNonBlank(StringTokenizer tokens) {
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (this.isBlank(token)) continue;
            return token;
        }
        return null;
    }

    private boolean isBlank(String aToken) {
        return " ".equals(aToken) || "\t".equals(aToken);
    }

    public boolean doesMatch(Map each) {
        Iterator iter = this.transformations.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        QueryOperation qop = (QueryOperation)iter.next();
        boolean result = qop.doesMatch(each);
        while (iter.hasNext()) {
            String logical = (String)iter.next();
            qop = (QueryOperation)iter.next();
            boolean nextResult = qop.doesMatch(each);
            if ("&".equals(logical)) {
                result &= nextResult;
            }
            if (!"|".equals(logical)) continue;
            result |= nextResult;
        }
        return result;
    }

    private String checkOperator(StringTokenizer tokens, String op) {
        boolean isValid = false;
        String newOp = this.nextNonBlank(tokens);
        if (newOp != null) {
            if ("=".equals(op = op + newOp)) {
                isValid = true;
            } else if ("!=".equals(op)) {
                isValid = true;
            } else if ("!".equals(op)) {
                return this.checkOperator(tokens, op);
            }
        }
        if (!isValid) {
            throw new UnsupportedOperationException("Invalid operator: " + op);
        }
        return op;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Object item : this.transformations) {
            buf.append(item.toString());
            buf.append(' ');
        }
        return buf.toString();
    }
}

