/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config;

import com.agimatec.commons.config.BooleanNode;
import com.agimatec.commons.config.DoubleNode;
import com.agimatec.commons.config.FileNode;
import com.agimatec.commons.config.IntNode;
import com.agimatec.commons.config.ListNode;
import com.agimatec.commons.config.LongNode;
import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.config.Node;
import com.agimatec.commons.config.TextNode;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class CompositeNode
extends Node {
    public Object getNode(String path) {
        StringTokenizer tokens = new StringTokenizer(path, "/");
        return this.evaluatePath(tokens, this);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        Object node = this.getNode(name);
        if (node == null) {
            return defaultValue;
        }
        if (node instanceof IntNode) {
            return ((IntNode)node).getValue();
        }
        return (Integer)node;
    }

    public long getLong(String name) {
        Object node = this.getNode(name);
        if (node == null) {
            return 0L;
        }
        if (node instanceof LongNode) {
            return ((LongNode)node).getValue();
        }
        return (Long)node;
    }

    public double getDouble(String name) {
        Object node = this.getNode(name);
        if (node == null) {
            return 0.0;
        }
        if (node instanceof DoubleNode) {
            return ((DoubleNode)node).getValue();
        }
        return (Double)node;
    }

    public String getString(String name) {
        Object node = this.getNode(name);
        if (node instanceof TextNode) {
            return ((TextNode)node).getValue();
        }
        return (String)node;
    }

    public boolean getBoolean(String name) {
        Object node = this.getNode(name);
        if (node == null) {
            return false;
        }
        if (node instanceof BooleanNode) {
            return ((BooleanNode)node).getValue();
        }
        return (Boolean)node;
    }

    public String getURLPath(String name) {
        FileNode fileNode = (FileNode)this.getNode(name);
        if (fileNode == null) {
            return null;
        }
        return fileNode.getURLPath();
    }

    public String getFilePath(String name) {
        FileNode fileNode = (FileNode)this.getNode(name);
        if (fileNode == null) {
            return null;
        }
        return fileNode.getFilePath();
    }

    public List getList(String path) {
        Object node = this.getNode(path);
        if (node == null) {
            return null;
        }
        if (node instanceof List) {
            return (List)node;
        }
        return ((ListNode)node).getList();
    }

    public Map getMap(String path) {
        Object node = this.getNode(path);
        if (node == null) {
            return null;
        }
        if (node instanceof Map) {
            return (Map)node;
        }
        return ((MapNode)node).getMap();
    }
}

