/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.ConfigWriter;
import com.agimatec.commons.config.sax.NodeHandler;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MapNodeHandler
extends NodeHandler {
    protected Class instanceClass;

    public MapNodeHandler(String aTag, Class theInstanceClass) {
        super(aTag);
        this.instanceClass = theInstanceClass;
    }

    protected Class getInstanceClass() {
        return this.instanceClass;
    }

    protected Object startNode(Attributes attr) throws SAXException {
        try {
            MapNode node = (MapNode)this.instanceClass.newInstance();
            this.setName(node, attr);
            return node;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    protected void acceptNode(ConfigContentHandler docHandler, Object aNode, Attributes attr) throws SAXException {
        String nam = this.getName(attr);
        if (nam == null) {
            this.throwNameRequired(aNode);
        }
        ((MapNode)docHandler.getCurrentNode()).getMap().put(nam, aNode);
    }

    protected void throwNameRequired(Object aNode) throws SAXException {
        throw new SAXException("name required when " + aNode + " is element of a " + this.tag());
    }

    protected void writeConfig(ConfigWriter writer, Object obj, Object parent, PrintWriter pw, int indent) throws SAXException {
        MapNode node = (MapNode)obj;
        pw.write(60);
        pw.write(this.tag());
        if (node.getName() != null) {
            pw.write(" name=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getName()));
            pw.write("\"");
        }
        pw.write(62);
        ArrayList myArrayList = new ArrayList();
        myArrayList.addAll(node.getMap().keySet());
        Collections.sort(myArrayList);
        Iterator iter = myArrayList.iterator();
        ++indent;
        while (iter.hasNext()) {
            Object myKey = iter.next();
            Object myValue = node.get(myKey);
            pw.write(10);
            this.printIndent(pw, indent);
            writer.writeNode(myValue, pw, indent, myKey);
        }
        pw.write(10);
        this.printIndent(pw, indent - 1);
        pw.write("</");
        pw.write(this.tag());
        pw.write(62);
    }
}

