/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.generator;

import com.agimatec.commons.generator.FreemarkerFileGenerator;
import com.agimatec.commons.generator.GeneratorSettings;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class GeneratorTool {
    protected GeneratorSettings settings;
    protected FreemarkerFileGenerator templateEngine;
    protected String dbms;

    public void generate(String templateBaseName) throws IOException, TemplateException {
        this.templateEngine.setBaseDir(this.settings.getDestDir());
        if (this.settings.isNoOutputFile()) {
            this.templateEngine.setDestFileName(null);
        } else {
            this.templateEngine.setDestFileName(this.getDestFile(templateBaseName));
        }
        this.templateEngine.setTemplateName(templateBaseName + ".ftl");
        this.templateEngine.generate();
    }

    public void initialize(GeneratorSettings settings) throws IOException {
        this.settings = settings;
        this.dbms = settings.getDbms();
        this.templateEngine = new FreemarkerFileGenerator(new File(settings.getTemplateDir() + "/" + this.dbms));
        this.templateEngine.putModel("catalog", settings.getCatalog());
        if (this.getConfig() != null) {
            this.templateEngine.putModel("config", this.getConfig());
        }
        this.templateEngine.putModel("dbms", this.dbms);
        if (settings.getProperties() != null && !settings.getProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : settings.getProperties().entrySet()) {
                this.templateEngine.putModel(entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract Object getConfig();

    protected abstract void readConfig(File var1) throws IOException, ClassNotFoundException;

    protected String getDestFile(String templateBaseName) {
        return templateBaseName + "-" + this.dbms + ".sql";
    }

    public void runMain(String[] args, GeneratorSettings settings) throws Exception {
        if (!settings.parseArgs(args)) {
            return;
        }
        this.readConfig(settings.getConfigFile() == null ? null : new File(settings.getConfigFile()));
        this.initialize(settings);
        for (String template : settings.getTemplates()) {
            this.generate(template);
        }
    }
}

