/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate;

import com.agimatec.commons.beans.MapQuery;
import com.agimatec.commons.config.BooleanNode;
import com.agimatec.commons.config.Config;
import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.FileNode;
import com.agimatec.commons.config.ListNode;
import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.config.TextNode;
import com.agimatec.commons.util.PropertyReplacer;
import com.agimatec.database.DbUnitDumpTool;
import com.agimatec.database.DbUnitSetupTool;
import com.agimatec.dbmigrate.HaltedException;
import com.agimatec.dbmigrate.MigrationTool;
import com.agimatec.dbmigrate.MigrationToolAware;
import com.agimatec.dbmigrate.action.ScriptAction;
import com.agimatec.dbmigrate.groovy.GroovyScriptTool;
import com.agimatec.dbmigrate.util.ConditionalScriptVisitor;
import com.agimatec.dbmigrate.util.DBVersionMeta;
import com.agimatec.dbmigrate.util.ReconnectScriptVisitor;
import com.agimatec.dbmigrate.util.SQLCursor;
import com.agimatec.dbmigrate.util.SubscriptCapableVisitor;
import com.agimatec.dbmigrate.util.UpdateVersionScriptVisitor;
import com.agimatec.jdbc.JdbcConfig;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcDatabaseFactory;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.meta.checking.DatabaseSchemaChecker;
import com.agimatec.sql.script.SQLScriptExecutor;
import com.agimatec.sql.script.SQLScriptParser;
import com.agimatec.sql.script.ScriptVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMigrationTool
implements MigrationTool {
    protected static final Logger log = LoggerFactory.getLogger((String)"agimatec.migration");
    protected JdbcDatabase targetDatabase;
    protected String migrateConfigFileName = "migration.xml";
    protected final DBVersionMeta dbVersionMeta = new DBVersionMeta();
    private String scriptsDir;

    public void setUp() {
        this.setupVersionMeta();
    }

    public void setConfigRootUrl(String configRoot) {
        ConfigManager.getDefault().setConfigRootPath(configRoot);
    }

    protected void setupVersionMeta() {
        MapNode versionMeta = (MapNode)this.getMigrateConfig().get("version-meta");
        if (versionMeta != null) {
            if (versionMeta.get("table") != null) {
                this.dbVersionMeta.setTableName(versionMeta.getString("table"));
            }
            if (versionMeta.get("version") != null) {
                this.dbVersionMeta.setColumn_version(versionMeta.getString("version"));
            }
            if (versionMeta.get("since") != null) {
                this.dbVersionMeta.setColumn_since(versionMeta.getString("since"));
            }
            if (versionMeta.get("insert-only") != null) {
                this.dbVersionMeta.setInsertOnly(versionMeta.getBoolean("insert-only"));
            }
            if (versionMeta.get("auto-create") != null) {
                this.dbVersionMeta.setAutoCreate(versionMeta.getBoolean("auto-create"));
            }
            if (versionMeta.get("auto-version") != null) {
                this.dbVersionMeta.setAutoVersion(versionMeta.getBoolean("auto-version"));
            }
        }
    }

    public void tearDown() throws Exception {
        this.terminateTransactions();
        this.disconnectDatabase();
    }

    public void halt(String message) {
        String date = DateFormat.getDateTimeInstance().format(new Date());
        throw new HaltedException("++ HALT at " + date + "! ++ " + message);
    }

    public void version(String dbVersion) throws JdbcException {
        try {
            UpdateVersionScriptVisitor.updateVersionInDatabase(this.targetDatabase, dbVersion, this.dbVersionMeta);
        }
        catch (Exception ex) {
            this.handleException("cannot update db-version to " + dbVersion, ex);
        }
    }

    public void execSQLScript(String scriptName) throws SQLException, IOException {
        SQLScriptExecutor visitor = new SQLScriptExecutor(this.targetDatabase);
        SQLScriptParser parser = new SQLScriptParser(this.getScriptsDir(), this.getLog());
        parser.setEnvironment(this.getEnvironment());
        parser.setFailOnError(true);
        parser.execSQLScript((ScriptVisitor)visitor, scriptName);
    }

    public void doSQLScript(String scriptName) throws IOException, SQLException {
        this.iterateSQLScript(new SQLScriptExecutor(this.targetDatabase), scriptName, true);
    }

    public void doSQLScriptIgnoreErrors(String scriptName) throws Exception {
        this.iterateSQLScript(new SQLScriptExecutor(this.targetDatabase), scriptName, false);
    }

    public void doSQLLines(String scriptName) throws IOException, SQLException {
        this.iterateSQLLines(new SQLScriptExecutor(this.targetDatabase), scriptName, true);
    }

    public void doSQLLinesIgnoreErrors(String scriptName) throws Exception {
        this.iterateSQLLines(new SQLScriptExecutor(this.targetDatabase), scriptName, false);
    }

    protected void iterateSQLLines(ScriptVisitor visitor, String scriptName, boolean failOnError) throws IOException, SQLException {
        SQLScriptParser parser = new SQLScriptParser(this.getScriptsDir(), this.getLog());
        Map env = this.getEnvironment();
        parser.setEnvironment(env);
        parser.setFailOnError(failOnError);
        visitor = new ReconnectScriptVisitor(this.targetDatabase, visitor);
        visitor = new SubscriptCapableVisitor(visitor, parser);
        visitor = new UpdateVersionScriptVisitor(this.targetDatabase, visitor, this.dbVersionMeta);
        visitor = new ConditionalScriptVisitor(visitor, env);
        parser.iterateSQLLines(visitor, scriptName);
    }

    public void checkObjectsValid(String databaseType) throws Exception {
        DatabaseSchemaChecker checker = DatabaseSchemaChecker.forDbms(databaseType);
        checker.setDatabase(this.getTargetDatabase());
        checker.assertObjectsValid();
    }

    public void checkSchemaComplete(String dev) throws Exception {
        StringTokenizer t = new StringTokenizer(dev, ",");
        String databaseType = t.nextToken();
        String configKey = t.nextToken();
        DatabaseSchemaChecker checker = DatabaseSchemaChecker.forDbms(databaseType);
        checker.setDatabase(this.getTargetDatabase());
        List<DatabaseSchemaChecker.Options> options = this.parseOptions(t);
        List<URL> urls = this.getURLsFromEnv(configKey, options);
        checker.checkDatabaseSchema(options, urls.toArray(new URL[urls.size()]));
    }

    protected List<DatabaseSchemaChecker.Options> parseOptions(StringTokenizer t) throws MalformedURLException {
        if (t.hasMoreTokens()) {
            ArrayList rawOptions;
            ArrayList<DatabaseSchemaChecker.Options> options = new ArrayList<DatabaseSchemaChecker.Options>();
            String optionsKey = t.nextToken();
            Object value = this.getEnvironment().get(optionsKey);
            ArrayList arrayList = value instanceof List ? (ArrayList)value : (rawOptions = value instanceof ListNode ? ((ListNode)value).getList() : null);
            if (rawOptions != null) {
                for (Object each : rawOptions) {
                    Map map = each instanceof Map ? (Map)each : ((MapNode)each).getMap();
                    DatabaseSchemaChecker.Options option = new DatabaseSchemaChecker.Options();
                    String format = (String)map.get("format");
                    if (format != null) {
                        option.format = ScriptAction.FileFormat.valueOf(format.toUpperCase());
                    }
                    options.add(option);
                }
            }
            return options;
        }
        return Collections.EMPTY_LIST;
    }

    private List<URL> getURLsFromEnv(String configKey, List<DatabaseSchemaChecker.Options> options) throws IOException {
        if (options == null || options.isEmpty()) {
            return this.getURLsFromEnv(configKey);
        }
        List files = (List)this.getEnvironment().get(configKey);
        Iterator filesIterator = files.iterator();
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator<DatabaseSchemaChecker.Options> optionsIterator = options.iterator();
        ArrayList<DatabaseSchemaChecker.Options> optionsCopy = new ArrayList<DatabaseSchemaChecker.Options>(options.size());
        while (filesIterator.hasNext()) {
            List<URL> urls0 = ConfigManager.toURLs((String)filesIterator.next());
            if (optionsIterator.hasNext()) {
                DatabaseSchemaChecker.Options options1 = optionsIterator.next();
                for (URL ignored : urls0) {
                    optionsCopy.add(options1);
                }
            }
            urls.addAll(urls0);
        }
        options.clear();
        options.addAll(optionsCopy);
        return urls;
    }

    private List<URL> getURLsFromEnv(String configKey) throws IOException {
        List files = (List)this.getEnvironment().get(configKey);
        Iterator it = files.iterator();
        ArrayList<URL> urls = new ArrayList<URL>();
        while (it.hasNext()) {
            urls.addAll(ConfigManager.toURLs((String)it.next()));
        }
        return urls;
    }

    public void dbSetup(String files) throws Exception {
        DbUnitSetupTool tool = new DbUnitSetupTool();
        this.invokeBeanCallbacks(tool);
        String[] parts = files.split(",");
        if (parts.length == 2) {
            tool.setDeleteDataFile(parts[0]);
            tool.setDataFile(parts[1]);
        } else if (parts.length == 1) {
            tool.setDeleteDataFile(null);
            tool.setDataFile(parts[0]);
        }
        tool.execute();
    }

    public void copyFiles(String configKey) throws IOException {
        List<URL> urls = this.getURLsFromEnv(configKey);
        Iterator<URL> it = urls.iterator();
        while (it.hasNext()) {
            URL source = it.next();
            URL target = it.next();
            File ftarget = FileUtils.toFile((URL)target);
            this.log("Copy " + source + " --> " + ftarget);
            try {
                FileUtils.copyURLToFile((URL)source, (File)ftarget);
            }
            catch (FileNotFoundException ex) {
                log.info("file to backup-copy not found, source: " + source + " target: " + ftarget);
                if (!ftarget.exists()) continue;
                ftarget.delete();
            }
        }
    }

    public void dbDump(String file) throws Exception {
        DbUnitDumpTool tool = new DbUnitDumpTool();
        this.invokeBeanCallbacks(tool);
        tool.setDataFile(file);
        tool.execute();
    }

    public void invokeStatic(String classMethod) throws Exception {
        this.invokeClassMethod(true, classMethod);
    }

    public void invokeBean(String classMethod) throws Exception {
        this.invokeClassMethod(false, classMethod);
    }

    protected void invokeClassMethod(boolean isStatic, String classMethod) throws Exception {
        Object[] args = this.splitMethodArgs(classMethod);
        Class<?> clazz = Class.forName((String)args[0]);
        Object receiver = null;
        if (!isStatic) {
            receiver = clazz.newInstance();
            this.invokeBeanCallbacks(receiver);
        }
        if (args[2] == null) {
            Method m = clazz.getMethod((String)args[1], new Class[0]);
            m.invoke(receiver, new Object[0]);
        } else {
            List params = (List)args[2];
            Method m = this.findMethod(clazz, (String)args[1], params.size());
            m.invoke(receiver, params.toArray());
        }
    }

    public void doGroovyScript(String scriptInvocation) throws Exception {
        GroovyScriptTool tool = new GroovyScriptTool(this.getGroovyScriptsDirs());
        this.invokeBeanCallbacks(tool);
        List<String> params = this.splitParams(scriptInvocation);
        int idx = scriptInvocation.indexOf("(");
        if (idx > 0) {
            scriptInvocation = scriptInvocation.substring(0, idx);
        }
        tool.getBinding().setVariable("params", params);
        tool.start(scriptInvocation);
    }

    protected void invokeBeanCallbacks(Object receiver) {
        if (receiver instanceof MigrationToolAware) {
            ((MigrationToolAware)receiver).setMigrationTool(this);
        }
    }

    protected Method findMethod(Class clazz, String methodName, int paramCount) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != paramCount) continue;
            return m;
        }
        return null;
    }

    protected Object[] splitMethodArgs(String classMethod) {
        int pos = classMethod.lastIndexOf(35);
        String clazzName = classMethod.substring(0, pos);
        String methodName = classMethod.substring(pos + 1);
        if ((pos = methodName.indexOf(40)) > 0) {
            methodName = methodName.substring(0, pos);
        }
        return new Object[]{clazzName, methodName, this.splitParams(classMethod)};
    }

    protected List<String> splitParams(String methodName) {
        int pos = methodName.indexOf(40);
        ArrayList<String> params = null;
        if (pos > 0) {
            StringTokenizer paramTokens = new StringTokenizer(methodName.substring(pos + 1), "(,)");
            params = new ArrayList<String>();
            while (paramTokens.hasMoreTokens()) {
                params.add(paramTokens.nextToken());
            }
        }
        return params;
    }

    protected void iterateSQLScript(ScriptVisitor visitor, String scriptName, boolean failOnError) throws IOException, SQLException {
        SQLScriptParser parser = new SQLScriptParser(this.getScriptsDir(), this.getLog());
        Map env = this.getEnvironment();
        parser.setEnvironment(env);
        parser.setFailOnError(failOnError);
        visitor = new ReconnectScriptVisitor(this.targetDatabase, visitor);
        visitor = new SubscriptCapableVisitor(visitor, parser);
        visitor = new UpdateVersionScriptVisitor(this.targetDatabase, visitor, this.dbVersionMeta);
        visitor = new ConditionalScriptVisitor(visitor, env);
        parser.iterateSQLScript(visitor, scriptName);
    }

    public DBVersionMeta getDbVersionMeta() {
        return this.dbVersionMeta;
    }

    @Override
    public Map getEnvironment() {
        Map env;
        Map m = this.getMigrateConfig().getMap("env");
        if (m == null) {
            Properties p = new Properties(System.getProperties());
            this.getMigrateConfig().put("env", p);
            env = p;
        } else if (m instanceof Properties) {
            env = m;
        } else {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)m);
            p.putAll((Map<?, ?>)System.getProperties());
            this.getMigrateConfig().put("env", p);
            env = p;
        }
        this.replaceProperties(env);
        return env;
    }

    protected void replaceProperties(Map env) {
        IdentityHashMap<Object, Object> done = new IdentityHashMap<Object, Object>();
        this.replaceInMap(new PropertyReplacer(env), env, done);
    }

    private void replaceInMap(PropertyReplacer replacer, Map map, IdentityHashMap<Object, Object> done) {
        if (done.put(map, map) != null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if ((value = this.replaceValue(replacer, value, done)) == null) continue;
            entry.setValue(value);
        }
    }

    private void replaceInList(PropertyReplacer replacer, List list, IdentityHashMap<Object, Object> done) {
        if (done.put(list, list) != null) {
            return;
        }
        int idx = 0;
        for (Object each : list) {
            if ((each = this.replaceValue(replacer, each, done)) != null) {
                list.set(idx, each);
            }
            ++idx;
        }
    }

    private Object replaceValue(PropertyReplacer replacer, Object value, IdentityHashMap done) {
        if (value instanceof String) {
            return replacer.replaceProperties((String)value);
        }
        if (value instanceof TextNode) {
            return replacer.replaceProperties(((TextNode)value).getValue());
        }
        if (value instanceof Map) {
            this.replaceInMap(replacer, (Map)value, done);
        } else if (value instanceof List) {
            this.replaceInList(replacer, (List)value, done);
        } else if (value instanceof ListNode) {
            this.replaceInList(replacer, ((ListNode)value).getList(), done);
        } else if (value instanceof MapNode) {
            this.replaceInMap(replacer, ((MapNode)value).getMap(), done);
        }
        return null;
    }

    @Override
    public JdbcDatabase getTargetDatabase() {
        return this.targetDatabase;
    }

    public Config getMigrateConfig() {
        Config migCfg = ConfigManager.getDefault().getConfig("migration", this.getMigrateConfigFileName());
        if (migCfg == null) {
            migCfg = new Config();
            ConfigManager.getDefault().cacheConfig(migCfg, "migration");
        }
        return migCfg;
    }

    private String getMigrateConfigFileName() {
        return this.migrateConfigFileName;
    }

    public void setMigrateConfigFileName(String migrateConfigFileName) {
        this.migrateConfigFileName = migrateConfigFileName;
    }

    protected List getOperations(String name) {
        return this.getMigrateConfig().getList("Operations/" + name);
    }

    public String getScriptsDir() {
        if (this.scriptsDir == null) {
            FileNode dir = (FileNode)this.getMigrateConfig().get("Scripts");
            if (dir == null) {
                return null;
            }
            this.scriptsDir = dir.getFilePath();
        }
        return this.scriptsDir;
    }

    public String[] getGroovyScriptsDirs() {
        if (this.getMigrateConfig().getList("GroovyScripts") != null) {
            List list = this.getMigrateConfig().getList("GroovyScripts");
            ArrayList<String> urls = new ArrayList<String>(list.size() + 1);
            if (this.getScriptsDir() != null) {
                urls.add(this.getScriptsDir());
            }
            for (Object each : list) {
                if (each instanceof FileNode) {
                    urls.add(((FileNode)each).getFilePath());
                    continue;
                }
                urls.add(String.valueOf(each));
            }
            return urls.toArray(new String[urls.size()]);
        }
        if (this.getScriptsDir() == null) {
            return null;
        }
        return new String[]{this.getScriptsDir()};
    }

    public void setScriptsDir(String scriptsDir) {
        this.scriptsDir = scriptsDir;
    }

    protected void perform(List operations) throws Exception {
        if (operations == null) {
            return;
        }
        for (Object each : operations) {
            if (each instanceof TextNode) {
                TextNode node = (TextNode)each;
                this.doMethodOperation(node.getName(), node.getValue());
                continue;
            }
            if (!(each instanceof ListNode)) continue;
            MapQuery q = new MapQuery(((ListNode)each).getName());
            boolean isTrue = q.doesMatch(this.getEnvironment());
            this.print("Found condition: (" + q.toString() + ") = " + isTrue);
            if (!isTrue) continue;
            this.perform(((ListNode)each).getList());
            this.print("End of Condition: (" + q.toString() + ")");
        }
    }

    public void doMethodOperation(String methodName, String methodParam) throws Exception {
        this.print("Next operation: " + methodName + "(\"" + methodParam + "\")");
        Method method = this.getClass().getMethod(methodName, String.class);
        try {
            method.invoke((Object)this, methodParam);
        }
        catch (InvocationTargetException tex) {
            this.rollback();
            this.log(tex.getTargetException());
            throw (Exception)tex.getTargetException();
        }
    }

    public void connectTargetDatabase() {
        if (this.targetDatabase == null) {
            String dbFile = this.getJdbcConfigFile();
            JdbcConfig databaseConfig = new JdbcConfig();
            if (dbFile != null) {
                this.print("Connect to JDBC using " + dbFile + "...");
                databaseConfig.read(dbFile);
            }
            this.applyEnvironment(databaseConfig);
            this.targetDatabase = this.createDatabase(databaseConfig);
            if (this.getTargetDatabase() != null) {
                try {
                    this.getTargetDatabase().begin();
                }
                catch (JdbcException ex) {
                    this.handleException("initial connect to database failed", ex);
                }
            }
        }
    }

    protected void handleException(String msg, Exception ex) {
        if (this.isFailOnError()) {
            this.getLog().error(msg, (Throwable)ex);
            if (ex instanceof JdbcException) {
                throw (JdbcException)ex;
            }
            throw new JdbcException(ex);
        }
        this.getLog().warn(msg + ": " + ex.getMessage());
    }

    protected JdbcDatabase createDatabase(JdbcConfig databaseConfig) {
        return JdbcDatabaseFactory.createInstance(databaseConfig);
    }

    protected void applyEnvironment(JdbcConfig jdbcConfig) {
        Map env = this.getEnvironment();
        Object v = env.get("DB_USER");
        if (v != null) {
            jdbcConfig.getProperties().put("user", v);
        }
        if ((v = env.get("DB_PASSWORD")) != null) {
            jdbcConfig.getProperties().put("password", v);
        }
        if ((v = env.get("DB_URL")) != null) {
            jdbcConfig.setConnect((String)v);
        }
        if ((v = env.get("DB_SCHEMA")) != null) {
            String urlConnect = ReconnectScriptVisitor.replaceJdbcSchemaName(jdbcConfig.getConnect(), (String)v);
            jdbcConfig.setConnect(urlConnect);
        }
        if ((v = env.get("DB_DRIVER")) != null) {
            jdbcConfig.setDriver((String)v);
        }
    }

    @Deprecated
    protected void commit() {
        this.assertConnection();
        this.getTargetDatabase().commit();
        log.info("** commit **");
    }

    protected String getJdbcConfigFile() {
        return this.getMigrateConfig().getURLPath("JdbcConfig");
    }

    public void print(Object obj) {
        System.out.println("agimatec.migration: " + obj);
        this.log(obj);
    }

    public void log(Object obj) {
        if (obj instanceof Throwable) {
            this.getLog().error(null, (Throwable)obj);
        } else {
            this.getLog().info(String.valueOf(obj));
        }
    }

    public Logger getLog() {
        return log;
    }

    public void rollback() throws Exception {
        try {
            this.log("** rollback **");
            if (this.getTargetDatabase() == null) {
                return;
            }
            this.getTargetDatabase().rollback();
        }
        catch (Exception ex) {
            this.getLog().error(null, (Throwable)ex);
        }
    }

    public void terminateTransactions() throws Exception {
        if (this.targetDatabase != null && this.getTargetDatabase().isTransaction()) {
            try {
                this.getTargetDatabase().commit();
            }
            catch (Exception ex) {
                this.getLog().error(null, (Throwable)ex);
            }
        }
    }

    public void disconnectDatabase() throws Exception {
        if (this.targetDatabase != null) {
            this.targetDatabase.close();
            this.targetDatabase = null;
        }
    }

    protected boolean acceptDirectoryForSQLParser(File aDirectory) {
        return !aDirectory.getName().equalsIgnoreCase("packages") && !aDirectory.getName().equalsIgnoreCase("triggers");
    }

    protected SQLCursor sqlSelect(String sql) throws SQLException {
        Statement stmt = this.assertConnection().createStatement();
        return new SQLCursor(stmt, stmt.executeQuery(sql));
    }

    protected Connection assertConnection() throws JdbcException {
        if (this.getTargetDatabase().getConnection() == null) {
            throw new JdbcException("database not connected");
        }
        return this.getTargetDatabase().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sqlExec(String sql) throws SQLException {
        Statement stmt = this.assertConnection().createStatement();
        int rowsAffected = -1;
        try {
            rowsAffected = stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        return rowsAffected;
    }

    public void setTargetDatabase(JdbcDatabase targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    protected boolean isFailOnError() {
        Object value = this.getEnvironment().get("FAIL_ON_ERROR");
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).getValue();
        }
        return true;
    }
}

