/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.groovy;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.util.ClassUtils;
import com.agimatec.dbmigrate.MigrationTool;
import com.agimatec.dbmigrate.MigrationToolAware;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class GroovyScriptTool
implements MigrationToolAware {
    private GroovyScriptEngine scriptEngine;
    private Binding binding = new Binding();

    public GroovyScriptTool(String rootDir) throws IOException {
        if (rootDir == null) {
            this.scriptEngineFromCP();
        } else {
            this.scriptEngineFromDirs(new String[]{rootDir});
        }
    }

    public GroovyScriptTool(String[] rootDirs) throws IOException {
        if (rootDirs == null) {
            this.scriptEngineFromCP();
        } else {
            this.scriptEngineFromDirs(rootDirs);
        }
    }

    private void scriptEngineFromDirs(String[] rootDirs) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(rootDirs.length * 3);
        for (String each : rootDirs) {
            urls.addAll(ConfigManager.toURLs(each));
        }
        this.scriptEngine = new GroovyScriptEngine(urls.toArray(new URL[urls.size()]), ClassUtils.getClassLoader());
    }

    private void scriptEngineFromCP() throws IOException {
        List<URL> urls = ConfigManager.toURLs("cp://");
        this.scriptEngine = new GroovyScriptEngine(urls.toArray(new URL[urls.size()]), ClassUtils.getClassLoader());
    }

    public void start(String groovyScript) throws ScriptException, ResourceException {
        this.scriptEngine.run(groovyScript, this.binding);
    }

    public void setMigrationTool(MigrationTool tool) {
        this.binding.setVariable("tool", (Object)tool);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public GroovyScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }
}

