/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectScriptVisitor
extends ScriptVisitorDelegate {
    private static final Logger log = LoggerFactory.getLogger(ReconnectScriptVisitor.class);
    private JdbcDatabase store;

    public ReconnectScriptVisitor(JdbcDatabase targetStore, ScriptVisitor visitor) {
        super(visitor);
        this.store = targetStore;
    }

    public int visitStatement(String statement) throws SQLException {
        if (statement.toUpperCase().startsWith("CONNECT ")) {
            try {
                this.reconnect(statement);
                return 0;
            }
            catch (JdbcException ex) {
                log.debug("error during reconnect()", (Throwable)ex);
                throw new SQLException(ex.getMessage());
            }
        }
        return super.visitStatement(statement);
    }

    private void reconnect(String connectCmd) {
        ReconnectScriptVisitor.reconnect(this.store, connectCmd);
    }

    public static void reconnect(JdbcDatabase store, String connectCmd) {
        String url;
        if (log.isInfoEnabled()) {
            log.info(connectCmd);
        }
        String driver = store.getDriverClassName();
        Properties props = new Properties(store.getProperties());
        StringTokenizer tokens = new StringTokenizer(connectCmd, " /@", false);
        tokens.nextToken();
        String user = tokens.nextToken();
        String pw = tokens.nextToken();
        props.put("user", user);
        props.put("password", pw);
        int idx = connectCmd.indexOf(64);
        if (idx >= 0) {
            url = connectCmd.substring(connectCmd.indexOf(64) + 1).trim();
            if (connectCmd.indexOf(58) < 0) {
                url = ReconnectScriptVisitor.replaceJdbcSchemaName(store.getConnectionString(), url);
            }
        } else {
            url = null;
        }
        if (store.isTransaction()) {
            store.commit();
        }
        store.close();
        store.init(driver, url, props);
        store.begin();
    }

    public static String replaceJdbcSchemaName(String jdbcUrl, String schemaname) {
        if (jdbcUrl == null || jdbcUrl.endsWith("/")) {
            return jdbcUrl + schemaname;
        }
        return jdbcUrl.substring(0, jdbcUrl.lastIndexOf(47) + 1) + schemaname;
    }

    public static String replaceTNSName(String jdbcUrl, String schemaname) {
        String url = jdbcUrl;
        url = url.substring(0, url.indexOf(64) + 1);
        url = url + schemaname;
        return url;
    }
}

