/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.agimatec.dbtransform.DataType;
import com.agimatec.dbtransform.DataTypeTransformation;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.TableDescription;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@XStreamAlias(value="conversion")
public class CatalogConversion {
    private final String name;
    private int maxLengthForConstraints;
    private boolean filterIndices;
    private final List<DataTypeTransformation> dataTypes = new ArrayList<DataTypeTransformation>();
    private Set<String> globalUniqueNames;

    public CatalogConversion(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataType matchDataType(DataType from) {
        for (DataTypeTransformation entry : this.dataTypes) {
            if (!entry.getSource().match(from)) continue;
            DataType dt = entry.getTarget().deepCopy();
            if (dt.isPrecisionEnabled() == null) {
                dt.setPrecisionEnabled(from.isPrecisionEnabled());
            }
            if (dt.getPrecision() == null && dt.isPrecisionEnabled() == Boolean.TRUE) {
                dt.setPrecision(from.getPrecision());
            }
            if (dt.getScale() == null) {
                dt.setScale(from.getScale());
            }
            return dt;
        }
        return from;
    }

    public void addTransformation(DataType from, DataType to) {
        this.dataTypes.add(new DataTypeTransformation(from, to));
    }

    public void addTransformation(String from, String to) {
        this.addTransformation(new DataType(from), new DataType(to));
    }

    public int getMaxLengthForConstraints() {
        return this.maxLengthForConstraints;
    }

    public void setMaxLengthForConstraints(int maxLengthForConstraints) {
        this.maxLengthForConstraints = maxLengthForConstraints;
    }

    public boolean isFilterIndices() {
        return this.filterIndices;
    }

    public void setFilterIndices(boolean filterIndices) {
        this.filterIndices = filterIndices;
    }

    public CatalogDescription transformCatalog(CatalogDescription catalog) {
        this.getGlobalUniqueNames().clear();
        CatalogDescription newCatalog = catalog.deepCopy();
        ArrayList<String> tableNames = new ArrayList<String>(newCatalog.getTables().keySet());
        Collections.sort(tableNames);
        for (String tableName : tableNames) {
            TableDescription newTable = newCatalog.getTable(tableName);
            TableDescription table = catalog.getTable(newTable.getTableName());
            this.transformTable(newTable, table);
        }
        return newCatalog;
    }

    public void transformTable(TableDescription newTable, TableDescription table) {
        int idx;
        for (idx = 0; idx < newTable.getColumnSize(); ++idx) {
            ColumnDescription column = table.getColumn(idx);
            ColumnDescription newColumn = newTable.getColumn(idx);
            this.transformColumn(newColumn, column);
        }
        for (idx = 0; idx < newTable.getConstraintSize(); ++idx) {
            IndexDescription constraint = table.getConstraint(idx);
            IndexDescription newContraint = newTable.getConstraint(idx);
            this.transformIndex(newContraint, constraint);
        }
        for (idx = 0; idx < newTable.getForeignKeySize(); ++idx) {
            ForeignKeyDescription fk = table.getForeignKey(idx);
            ForeignKeyDescription newFk = newTable.getForeignKey(idx);
            this.transformForeignKey(newFk, fk);
        }
        for (idx = 0; idx < table.getIndexSize(); ++idx) {
            IndexDescription index = table.getIndex(idx);
            IndexDescription newIndex = newTable.getIndex(index.getIndexName());
            if (this.isFilterIndices() && null != newTable.findConstraintForColumns(newIndex.getColumns())) {
                newTable.removeIndex(index.getIndexName());
                continue;
            }
            this.transformIndex(newIndex, index);
        }
        IndexDescription pkIndex = table.getPrimaryKey();
        IndexDescription newPkIndex = newTable.getPrimaryKey();
        if (newPkIndex != null && pkIndex != null) {
            this.transformIndex(newPkIndex, pkIndex);
        }
    }

    protected void transformForeignKey(ForeignKeyDescription newFk, ForeignKeyDescription fk) {
        newFk.setConstraintName(this.shortenName(fk.getConstraintName(), this.getGlobalUniqueNames()));
    }

    protected void transformIndex(IndexDescription newContraint, IndexDescription constraint) {
        newContraint.setIndexName(this.shortenName(constraint.getIndexName(), this.getGlobalUniqueNames()));
    }

    private Set getGlobalUniqueNames() {
        if (this.globalUniqueNames == null) {
            this.globalUniqueNames = new HashSet<String>();
        }
        return this.globalUniqueNames;
    }

    public void transformColumn(ColumnDescription newColumn, ColumnDescription column) {
        DataType dt = this.toDataType(column);
        DataType newDT = this.matchDataType(dt);
        newColumn.setTypeName(newDT.getTypeName());
        newColumn.setPrecision(newDT.getPrecision() == null ? 0 : newDT.getPrecision());
        newColumn.setPrecisionEnabled(newDT.isPrecisionEnabled() != null && newDT.isPrecisionEnabled() != false);
        newColumn.setScale(newDT.getScale() == null ? 0 : newDT.getScale());
        newColumn.setDefaultValue(this.convertDefaultValueFrom(newDT, dt, column.getDefaultValue()));
    }

    protected String convertDefaultValueFrom(DataType newDT, DataType dt, String defaultValue) {
        if (newDT.equals(dt) || defaultValue == null) {
            return defaultValue;
        }
        if (newDT.getTypeName().equals("NUMBER")) {
            if ("false".equalsIgnoreCase(defaultValue)) {
                return "0";
            }
            if ("true".equalsIgnoreCase(defaultValue)) {
                return "1";
            }
        }
        return defaultValue;
    }

    protected DataType toDataType(ColumnDescription column) {
        DataType dt = new DataType();
        dt.setTypeName(column.getTypeName());
        if (column.isPrecisionEnabled()) {
            dt.setPrecision(column.getPrecision());
            dt.setPrecisionEnabled(true);
        }
        if (column.getScale() != 0) {
            dt.setScale(column.getScale());
        }
        return dt;
    }

    protected String shortenName(String name, Set domain) {
        if (name == null) {
            return name;
        }
        if (name.length() > this.getMaxLengthForConstraints()) {
            String newName = name.substring(0, this.getMaxLengthForConstraints());
            if (domain.contains(newName)) {
                int i;
                String baseName = name.substring(0, this.getMaxLengthForConstraints() - 1);
                for (i = 1; i < 10 && domain.contains(newName = baseName + i); ++i) {
                }
                if (domain.contains(newName)) {
                    baseName = name.substring(0, this.getMaxLengthForConstraints() - 2);
                    for (i = 10; i < 100 && domain.contains(newName = baseName + i); ++i) {
                    }
                    if (domain.contains(newName)) {
                        return null;
                    }
                }
            }
            domain.add(newName);
            return newName;
        }
        domain.add(name);
        return name;
    }
}

