/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.agimatec.commons.generator.GeneratorSettings;
import java.io.IOException;

public class ScriptTransformatorSettings
extends GeneratorSettings {
    private String fromDir;
    private String targetDir;
    private String fromDbms = "postgres";
    private String prefix = "up-";
    private boolean overwrite = false;

    protected String defaultConfigFileName() {
        return "db-conversion.xml";
    }

    public boolean parseArgs(String[] args) throws IOException, ClassNotFoundException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-fromDir".equalsIgnoreCase(arg)) {
                this.fromDir = args[++i];
                continue;
            }
            if ("-targetDir".equalsIgnoreCase(arg)) {
                this.targetDir = args[++i];
                continue;
            }
            if ("-fromDbms".equalsIgnoreCase(arg)) {
                this.fromDbms = args[++i];
                continue;
            }
            if ("-overwrite".equalsIgnoreCase(arg)) {
                this.overwrite = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (!"-prefix".equalsIgnoreCase(arg)) continue;
            this.prefix = args[++i];
        }
        return super.parseArgs(args);
    }

    protected void printUsage() {
        super.printUsage();
        System.out.println("\t-fromDir \t (mandatory) dir with scripts to transform, e.g. postgres/upgrade");
        System.out.println("\t-targetDir \t (mandatory) dir to write output scripts to, e.g. oracle/upgrade");
        System.out.println("\t-fromDbms \t (optional) the source DBMS used to parse the scripts in 'fromDir', default: postgres");
        System.out.println("\t-overwrite \t (optional) overwrite target scripts (default: false), true/false");
        System.out.println("\t-prefix \t (optional) prefix of script files (default: up-)");
    }

    protected void checkValid() {
        if (this.dbms == null) {
            throw new IllegalArgumentException("no database given with option -dbms");
        }
        if (this.targetDir == null) {
            throw new IllegalArgumentException("no targetDir given with option -targetDir");
        }
        if (this.fromDir == null) {
            throw new IllegalArgumentException("no fromDir given with option -fromDir");
        }
    }

    public String getFromDir() {
        return this.fromDir;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public String getFromDbms() {
        return this.fromDbms;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

