/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform.ejb3;

import com.agimatec.dbtransform.ejb3.Ejb3Class;
import com.agimatec.dbtransform.ejb3.Ejb3Prototype;
import com.agimatec.dbtransform.ejb3.Ejb3Schema;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.TableDescription;
import org.apache.commons.lang.StringUtils;

public class Ejb3Relationship
extends Ejb3Prototype {
    protected final ForeignKeyDescription foreignKey;
    protected ColumnDescription column;
    protected ColumnDescription refColumn;
    protected Ejb3Class targetType;
    protected String attributeName;
    protected boolean optional = false;
    protected boolean oneToOne;
    private boolean primaryKeyJoin;

    public Ejb3Relationship(ForeignKeyDescription foreignKey) {
        this.foreignKey = foreignKey;
    }

    public ForeignKeyDescription getForeignKey() {
        return this.foreignKey;
    }

    public void generate(Ejb3Schema schema) {
        String colName;
        Ejb3Class targetEntity = schema.getEjb3classes().get(this.foreignKey.getRefTableName());
        if (targetEntity != null) {
            TableDescription refTable;
            this.targetType = targetEntity;
            TableDescription table = schema.getCatalog().getTable(this.foreignKey.getTableName());
            if (table != null) {
                this.column = table.getColumn(this.foreignKey.getColumn(0));
                this.oneToOne = table.isPrimaryKeyColumn(this.column.getColumnName());
                if (!this.oneToOne) {
                    this.oneToOne = table.isUnique(this.column.getColumnName());
                } else {
                    this.primaryKeyJoin = true;
                }
            }
            if ((refTable = schema.getCatalog().getTable(this.foreignKey.getRefTableName())) != null) {
                this.refColumn = refTable.getColumn(this.foreignKey.getRefColumn(0));
            }
        } else {
            this.targetType = new Ejb3Class(this.foreignKey.getRefTableName());
        }
        if (this.column == null) {
            this.column = new ColumnDescription();
            this.column.setColumnName(this.foreignKey.getColumn(0));
        }
        if (this.refColumn == null) {
            this.refColumn = new ColumnDescription();
            this.refColumn.setColumnName(this.foreignKey.getRefColumn(0));
        }
        if ((colName = this.foreignKey.getColumn(0)).endsWith("_id")) {
            colName = colName.substring(0, colName.length() - 3);
        }
        this.attributeName = this.toProperAttributeName(colName);
    }

    public String getType() {
        return "ManyToOne";
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public boolean isPrimaryKeyJoin() {
        return this.primaryKeyJoin;
    }

    public boolean isMapped() {
        return true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getGetter() {
        return "get" + StringUtils.capitalize((String)this.getAttributeName());
    }

    public String getSetter() {
        return "set" + StringUtils.capitalize((String)this.getAttributeName());
    }

    public Ejb3Class getTargetType() {
        return this.targetType;
    }

    public boolean isToMany() {
        return false;
    }

    public String getJavaType() {
        return this.getTargetType().getClassName();
    }

    public String toString() {
        return this.attributeName;
    }

    public ColumnDescription getColumn() {
        return this.column;
    }

    public ColumnDescription getRefColumn() {
        return this.refColumn;
    }

    public void setOneToOne(boolean b) {
        this.oneToOne = true;
    }
}

